/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageAction;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.util.Date;

public class WikiImportProperty
extends WikiPageProperty {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "WikiImport";

    private WikiImportProperty() {
    }

    public WikiImportProperty(String source) {
        this.set("Source", source);
    }

    public String getSourceUrl() {
        return this.get("Source");
    }

    public boolean isRoot() {
        return this.has("IsRoot");
    }

    public void setRoot(boolean value) {
        if (value) {
            this.set("IsRoot");
        } else {
            this.remove("IsRoot");
        }
    }

    public boolean isAutoUpdate() {
        return this.has("AutoUpdate");
    }

    public void setAutoUpdate(boolean value) {
        if (value) {
            this.set("AutoUpdate");
        } else {
            this.remove("AutoUpdate");
        }
    }

    public static boolean isImported(PageData pageData) {
        try {
            WikiImportProperty importProperty = WikiImportProperty.createFrom(pageData.getProperties());
            return importProperty != null && !importProperty.isRoot();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WikiImportProperty createFrom(WikiPageProperty property) {
        if (property.has(PROPERTY_NAME)) {
            WikiImportProperty importProperty = new WikiImportProperty();
            WikiPageProperty rawImportProperty = property.getProperty(PROPERTY_NAME);
            importProperty.set("Source", rawImportProperty.getProperty("Source"));
            importProperty.set("LastRemoteModification", rawImportProperty.getProperty("LastRemoteModification"));
            if (rawImportProperty.has("IsRoot")) {
                importProperty.set("IsRoot", rawImportProperty.getProperty("IsRoot"));
            }
            if (rawImportProperty.has("AutoUpdate")) {
                importProperty.set("AutoUpdate", rawImportProperty.getProperty("AutoUpdate"));
            }
            return importProperty;
        }
        return null;
    }

    public void addTo(WikiPageProperty rootProperty) {
        rootProperty.set(PROPERTY_NAME, this);
    }

    public void setLastRemoteModificationTime(Date date) {
        this.set("LastRemoteModification", WikiImportProperty.getTimeFormat().format(date));
    }

    public Date getLastRemoteModificationTime() throws Exception {
        Date date = new Date(0L);
        String strValue = this.get("LastRemoteModification");
        if (strValue != null) {
            date = WikiImportProperty.getTimeFormat().parse(strValue);
        }
        return date;
    }

    public static void handleImportProperties(HtmlPage html, WikiPage page, PageData pageData) throws Exception {
        html.actions.add(HtmlUtil.makeNavBreak());
        if (WikiImportProperty.isImported(pageData)) {
            html.body.addAttribute("class", "imported");
            WikiPagePath localPagePath = page.getPageCrawler().getFullPath(page);
            String localPageName = PathParser.render(localPagePath);
            html.actions.add(WikiImportProperty.makeEditLocallyLink(localPageName));
            html.actions.add(HtmlUtil.makeNavBreak());
            String remoteInput = WikiImportProperty.makeRemoteEditQueryParameters();
            WikiImportProperty importProperty = WikiImportProperty.createFrom(pageData.getProperties());
            html.actions.add(WikiImportProperty.makeEditRemotelyLink(remoteInput, importProperty.getSourceUrl()));
        } else if (page instanceof ProxyPage) {
            html.body.addAttribute("class", "virtual");
        }
    }

    private static HtmlTag makeEditRemotelyLink(String remoteInput, String pageName) {
        WikiPageAction action = new WikiPageAction(pageName, "Edit Remotely");
        action.setQuery(remoteInput);
        return HtmlUtil.makeAction(action);
    }

    private static HtmlTag makeEditLocallyLink(String localPageName) {
        WikiPageAction action = new WikiPageAction(localPageName, "Edit Locally");
        action.setQuery("edit");
        return HtmlUtil.makeAction(action);
    }

    public static String makeRemoteEditQueryParameters() {
        return "responder=edit&amp;redirectToReferer=true&amp;redirectAction=importAndView";
    }
}

