/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.ExecutionLog;
import fitnesse.responders.run.ExecutionStatus;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.HashMap;
import java.util.Map;

public class CompositeExecutionLog {
    private String errorLogPageName;
    private WikiPagePath errorLogPagePath;
    private PageCrawler crawler;
    private WikiPage root;
    private Map<String, ExecutionLog> logs = new HashMap<String, ExecutionLog>();

    public CompositeExecutionLog(WikiPage testPage) throws Exception {
        this.crawler = testPage.getPageCrawler();
        this.root = this.crawler.getRoot(testPage);
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.errorLogPagePath = this.crawler.getFullPath(testPage).addNameToFront("ErrorLogs");
        this.errorLogPageName = PathParser.render(this.errorLogPagePath);
    }

    public void add(String testSystemName, ExecutionLog executionLog) {
        this.logs.put(testSystemName, executionLog);
    }

    public void publish() throws Exception {
        String content = this.buildLogContent();
        WikiPage errorLogPage = this.crawler.addPage(this.root, this.errorLogPagePath);
        PageData data = errorLogPage.getData();
        data.setContent(content);
        errorLogPage.commit(data);
    }

    private String buildLogContent() throws Exception {
        StringBuffer logContent = new StringBuffer();
        for (String testSystemName : this.logs.keySet()) {
            logContent.append(String.format("!3 !-%s-!\n", testSystemName));
            logContent.append(this.logs.get(testSystemName).buildLogContent());
        }
        return logContent.toString();
    }

    public String executionStatusHtml() throws Exception {
        for (ExecutionLog log : this.logs.values()) {
            if (log.exceptionCount() == 0) continue;
            return ExecutionLog.makeExecutionStatusLink(this.errorLogPageName, ExecutionStatus.ERROR);
        }
        for (ExecutionLog log : this.logs.values()) {
            if (!log.hasCapturedOutput()) continue;
            return ExecutionLog.makeExecutionStatusLink(this.errorLogPageName, ExecutionStatus.OUTPUT);
        }
        return ExecutionLog.makeExecutionStatusLink(this.errorLogPageName, ExecutionStatus.OK);
    }
}

