/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.List;
import util.TimeMeasurement;

public class SuiteExecutionReportFormatter
extends BaseFormatter {
    private SuiteExecutionReport.PageHistoryReference referenceToCurrentTest;
    protected SuiteExecutionReport suiteExecutionReport = new SuiteExecutionReport();

    public SuiteExecutionReportFormatter(FitNesseContext context, WikiPage page) throws Exception {
        super(context, page);
        this.suiteExecutionReport.version = new FitNesseVersion().toString();
        this.suiteExecutionReport.rootPath = this.page.getName();
    }

    @Override
    public void writeHead(String pageType) throws Exception {
    }

    @Override
    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) throws Exception {
    }

    @Override
    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
    }

    @Override
    public void newTestStarted(WikiPage test, TimeMeasurement timeMeasurement) throws Exception {
        String pageName = PathParser.render(test.getPageCrawler().getFullPath(test));
        this.referenceToCurrentTest = new SuiteExecutionReport.PageHistoryReference(pageName, timeMeasurement.startedAt(), timeMeasurement.elapsed());
    }

    @Override
    public void testOutputChunk(String output) throws Exception {
    }

    public String getRootPageName() {
        return this.suiteExecutionReport.getRootPath();
    }

    public String getFitNesseVersion() {
        return new FitNesseVersion().toString();
    }

    @Override
    public void testComplete(WikiPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) throws Exception {
        this.referenceToCurrentTest.setTestSummary(testSummary);
        this.referenceToCurrentTest.setRunTimeInMillis(timeMeasurement.elapsed());
        this.suiteExecutionReport.addPageHistoryReference(this.referenceToCurrentTest);
        this.suiteExecutionReport.tallyPageCounts(testSummary);
        this.failCount += testSummary.wrong;
        this.failCount += testSummary.exceptions;
    }

    public List<SuiteExecutionReport.PageHistoryReference> getPageHistoryReferences() {
        return this.suiteExecutionReport.getPageHistoryReferences();
    }

    @Override
    public int getErrorCount() {
        return this.getPageCounts().wrong + this.getPageCounts().exceptions;
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        super.allTestingComplete(totalTimeMeasurement);
        this.suiteExecutionReport.setTotalRunTimeInMillis(totalTimeMeasurement);
    }

    public TestSummary getPageCounts() {
        return this.suiteExecutionReport.getFinalCounts();
    }
}

