/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlPageFactory;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.formatters.TestHtmlFormatter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import util.TimeMeasurement;

public abstract class SuiteHtmlFormatter
extends TestHtmlFormatter {
    private static final String cssSuffix1 = "1";
    private static final String cssSuffix2 = "2";
    private TestSummary pageCounts = new TestSummary();
    private static final String TEST_SUMMARIES_ID = "test_summaries";
    private String cssSuffix = "1";
    private int currentTest = 0;
    private String testSystemFullName = null;
    private boolean printedTestOutput = false;
    private int totalTests = 1;

    public SuiteHtmlFormatter(FitNesseContext context, WikiPage page, HtmlPageFactory pageFactory) throws Exception {
        super(context, page, pageFactory);
    }

    public SuiteHtmlFormatter(FitNesseContext context) {
        super(context);
    }

    public String getTestSystemHeader(String testSystemName) throws Exception {
        String tag = String.format("<h3>%s</h3>\n", testSystemName);
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript(TEST_SUMMARIES_ID, tag);
        return insertScript.html();
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
        super.announceNumberTestsToRun(testsToRun);
        this.totalTests = testsToRun != 0 ? testsToRun : 1;
    }

    public void announceStartNewTest(String relativeName, String fullPathName) throws Exception {
        ++this.currentTest;
        this.maybeWriteTestOutputDiv();
        this.maybeWriteTestSystem();
        this.updateSummaryDiv(this.getProgressHtml());
        this.writeTestOuputDiv(relativeName, fullPathName);
    }

    private void writeTestOuputDiv(String relativeName, String fullPathName) throws Exception {
        HtmlTag pageNameBar = HtmlUtil.makeDivTag("test_output_name");
        HtmlTag anchor = HtmlUtil.makeLink(fullPathName, relativeName);
        anchor.addAttribute("id", relativeName + this.currentTest);
        anchor.addAttribute("class", "test_name");
        HtmlTag topLink = HtmlUtil.makeLink("#test_summaries", "Top");
        topLink.addAttribute("class", "top_of_page");
        pageNameBar.add(anchor);
        pageNameBar.add(topLink);
        this.writeData(pageNameBar.html());
        this.writeData("<div class=\"alternating_block_" + this.cssSuffix + "\">");
    }

    private void maybeWriteTestOutputDiv() throws Exception {
        if (!this.printedTestOutput) {
            HtmlTag outputTitle = new HtmlTag("h2", "Test Output");
            outputTitle.addAttribute("class", "centered");
            this.writeData(outputTitle.html());
            this.printedTestOutput = true;
        }
    }

    private void maybeWriteTestSystem() throws Exception {
        if (this.testSystemFullName != null) {
            HtmlTag systemTitle = new HtmlTag("h2", String.format("Test System: %s", this.testSystemFullName));
            systemTitle.addAttribute("class", "centered");
            this.writeData(systemTitle.html());
            this.testSystemFullName = null;
        }
    }

    @Override
    public void newTestStarted(WikiPage newTest, TimeMeasurement timeMeasurement) throws Exception {
        String relativeName = this.getRelativeName(newTest);
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath(newTest);
        String fullPathName = PathParser.render(fullPath);
        this.announceStartNewTest(relativeName, fullPathName);
    }

    private String getProgressHtml() throws Exception {
        float percentFinished = (this.currentTest - 1) * 1000 / this.totalTests;
        percentFinished /= 10.0f;
        String text = "Running tests ... (" + this.currentTest + "/" + this.totalTests + ")";
        text = text.replaceAll(" ", "&nbsp;");
        HtmlTag progressDiv = new HtmlTag("div", text);
        String cssClass = this.currentTest == 1 ? "pass" : this.cssClassFor(this.pageCounts);
        progressDiv.addAttribute("id", "progressBar");
        progressDiv.addAttribute("class", cssClass);
        progressDiv.addAttribute("style", "width:" + percentFinished + "%");
        return progressDiv.html();
    }

    @Override
    public void processTestResults(String relativeName, TestSummary testSummary) throws Exception {
        this.finishOutputForTest();
        this.getAssertionCounts().add(testSummary);
        this.switchCssSuffix();
        HtmlTag mainDiv = HtmlUtil.makeDivTag("alternating_row_" + this.cssSuffix);
        mainDiv.add(HtmlUtil.makeSpanTag("test_summary_results " + this.cssClassFor(testSummary), testSummary.toString()));
        HtmlTag link = HtmlUtil.makeLink("#" + relativeName + this.currentTest, relativeName);
        link.addAttribute("class", "test_summary_link");
        mainDiv.add(link);
        if (this.latestTestTime != null) {
            mainDiv.add(HtmlUtil.makeSpanTag("", String.format("(%.03f seconds)", this.latestTestTime.elapsedSeconds())));
        }
        this.pageCounts.tallyPageCounts(testSummary);
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript(TEST_SUMMARIES_ID, mainDiv.html(2));
        this.writeData(insertScript.html());
    }

    protected TestSummary getFinalSummary() {
        return this.pageCounts;
    }

    private void finishOutputForTest() throws Exception {
        this.writeData("</div>" + HtmlTag.endl);
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        this.latestTestTime = totalTimeMeasurement;
        super.allTestingComplete(totalTimeMeasurement);
    }

    private void switchCssSuffix() {
        this.cssSuffix = cssSuffix1.equals(this.cssSuffix) ? cssSuffix2 : cssSuffix1;
    }

    @Override
    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) throws Exception {
        this.testSystemFullName = (testSystemName + ":" + testRunner).replaceAll("\\\\", "/");
        String tag = String.format("<h3>%s</h3>\n", this.testSystemFullName);
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript(TEST_SUMMARIES_ID, tag);
        this.writeData(insertScript.html());
    }

    @Override
    protected String makeSummaryContent() {
        String testPagesSummary = "<strong>Test Pages:</strong> " + this.pageCounts.toString() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        return testPagesSummary + super.makeSummaryContent();
    }

    @Override
    public void finishWritingOutput() throws Exception {
        this.writeData(this.testSummary());
        this.writeData(this.getHtmlPage().postDivision);
    }

    @Override
    public void writeHead(String pageType) throws Exception {
        super.writeHead(pageType);
        HtmlTag outputTitle = new HtmlTag("h2", "Test Summaries");
        outputTitle.addAttribute("class", "centered");
        HtmlTag summariesDiv = HtmlUtil.makeDivTag(TEST_SUMMARIES_ID);
        summariesDiv.addAttribute("id", TEST_SUMMARIES_ID);
        summariesDiv.add(outputTitle);
        this.writeData(summariesDiv.html());
    }
}

