/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.FitNesseContext;
import fitnesse.components.ContentBuffer;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlPageFactory;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.formatters.SuiteHtmlFormatter;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import java.io.InputStream;

public class HtmlResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer;
    private boolean closed = false;
    private SuiteHtmlFormatter suiteFormatter;
    private FitNesseContext context;
    private String host;
    private String rootPath;
    private HtmlPage htmlPage;
    public static final String scriptContent = "\nfunction localizeInPageLinks()\n{\n\tvar base = document.getElementsByTagName('base')[0].href;\n\tvar inPageBase = base + \"#\";\n\tvar baseLength = inPageBase.length\n\tvar aTags = document.getElementsByTagName('a');\n\tfor(var i=0; i < aTags.length; i++)\n\t{\n\t\tvar tag = aTags[i];\n\t\tif(tag.href && tag.href.substring(0, baseLength) == inPageBase)\n\t\t\ttag.href = location.href + '#' + tag.href.substring(baseLength);\n\t}\n}\n";

    public HtmlResultFormatter(FitNesseContext context, String host, String rootPath) throws Exception {
        this.context = context;
        this.host = host;
        this.rootPath = rootPath;
        this.buffer = new ContentBuffer(".html");
        this.createPage(context.htmlPageFactory, rootPath);
        this.suiteFormatter = this.createCustomFormatter();
        this.suiteFormatter.writeHead(null);
    }

    private SuiteHtmlFormatter createCustomFormatter() throws Exception {
        SuiteHtmlFormatter formatter = new SuiteHtmlFormatter(this.context){

            @Override
            protected void writeData(String output) throws Exception {
                HtmlResultFormatter.this.buffer.append(output);
            }

            @Override
            protected HtmlPage buildHtml(String pageType) throws Exception {
                return HtmlResultFormatter.this.htmlPage;
            }
        };
        return formatter;
    }

    private void createPage(HtmlPageFactory pageFactory, String rootPath) throws Exception {
        this.htmlPage = pageFactory.newPage();
        this.htmlPage.head.use(this.makeBaseTag());
        this.htmlPage.head.add(this.makeContentTypeMetaTag());
        this.htmlPage.title.use(rootPath);
        this.htmlPage.head.add(this.htmlPage.title);
        this.htmlPage.head.add(this.htmlPage.makeCssLink("/files/css/fitnesse_print.css", "screen"));
        HtmlTag script = new HtmlTag("script", scriptContent);
        script.addAttribute("language", "javascript");
        this.htmlPage.head.add(script);
        this.htmlPage.body.addAttribute("onload", "localizeInPageLinks()");
        this.htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(rootPath, "Command Line Test Results"));
    }

    private HtmlTag makeContentTypeMetaTag() {
        HtmlTag meta = new HtmlTag("meta");
        meta.addAttribute("http-equiv", "Content-Type");
        meta.addAttribute("content", "text/html; charset=utf-8");
        return meta;
    }

    private HtmlTag makeBaseTag() {
        HtmlTag base = new HtmlTag("base");
        StringBuffer href = new StringBuffer("http://");
        href.append(this.host);
        href.append("/");
        base.addAttribute("href", href.toString());
        return base;
    }

    @Override
    public void acceptResult(PageResult result) throws Exception {
        String relativePageName = result.title();
        this.suiteFormatter.announceStartNewTest(relativePageName, this.rootPath + "." + relativePageName);
        this.suiteFormatter.testOutputChunk(result.content());
        this.suiteFormatter.processTestResults(relativePageName, result.testSummary());
    }

    @Override
    public void acceptFinalCount(TestSummary testSummary) throws Exception {
        this.suiteFormatter.testSummary();
        this.suiteFormatter.finishWritingOutput();
    }

    private void close() throws Exception {
        if (!this.closed) {
            this.suiteFormatter.finishWritingOutput();
            this.closed = true;
        }
    }

    @Override
    public int getByteCount() throws Exception {
        this.close();
        return this.buffer.getSize();
    }

    @Override
    public InputStream getResultStream() throws Exception {
        this.close();
        return this.buffer.getInputStream();
    }
}

