/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ListExecutor;
import fitnesse.slim.SlimClient;
import fitnesse.slim.SlimError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public abstract class ListExecutorTestBase {
    protected List<Object> statements;
    protected ListExecutor executor;
    protected List<Object> expectedResults = new ArrayList<Object>();
    protected String testClass = "TestSlim";

    protected abstract ListExecutor getListExecutor() throws Exception;

    protected abstract String getTestClassPath();

    @Before
    public void setup() throws Exception {
        this.executor = this.getListExecutor();
        this.statements = new ArrayList<Object>();
        this.statements.add(ListUtility.list("i1", "import", this.getTestClassPath()));
        this.statements.add(ListUtility.list("m1", "make", "testSlim", this.testClass));
        this.expectedResults.add(ListUtility.list("i1", "OK"));
        this.expectedResults.add(ListUtility.list("m1", "OK"));
    }

    protected void respondsWith(List<Object> expected) {
        this.expectedResults.addAll(expected);
        List<Object> result = this.executor.execute(this.statements);
        Map<String, Object> expectedMap = SlimClient.resultToMap(this.expectedResults);
        Map<String, Object> resultMap = SlimClient.resultToMap(result);
        Assert.assertEquals(expectedMap, resultMap);
    }

    @Test
    public void checkSetup() {
        this.respondsWith(ListUtility.list());
    }

    @Test
    public void invalidOperation() throws Exception {
        this.statements.add(ListUtility.list("inv1", "invalidOperation"));
        this.assertExceptionReturned("message:<<INVALID_STATEMENT: invalidOperation.>>", "inv1");
    }

    @Test(expected=SlimError.class)
    public void malformedStatement() throws Exception {
        this.statements.add(ListUtility.list("id", "call", "notEnoughArguments"));
        this.assertExceptionReturned("XX", "id");
    }

    private void assertExceptionReturned(String message, String returnTag) {
        String result;
        Map<String, Object> results = SlimClient.resultToMap(this.executor.execute(this.statements));
        Assert.assertTrue((String)result, ((result = (String)results.get(returnTag)).indexOf("__EXCEPTION__:") != -1 && result.indexOf(message) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void noSuchInstance() throws Exception {
        this.statements.add(ListUtility.list("id", "call", "noSuchInstance", "noSuchMethod"));
        this.assertExceptionReturned("message:<<NO_INSTANCE noSuchInstance.>>", "id");
    }

    @Test
    public void emptyListReturnsNicely() throws Exception {
        this.statements.clear();
        this.executor.execute(this.statements);
        this.expectedResults.clear();
        this.respondsWith(ListUtility.list());
    }

    @Test
    public void createWithFullyQualifiedNameWorks() throws Exception {
        this.statements.clear();
        this.statements.add(ListUtility.list("m1", "make", "testSlim", this.getTestClassPath() + "." + this.testClass));
        this.expectedResults.clear();
        this.respondsWith(ListUtility.list(ListUtility.list("m1", "OK")));
    }

    @Test
    public void exceptionInConstructorIsPassedThrough() throws Exception {
        this.statements.clear();
        this.expectedResults.clear();
        this.statements.add(ListUtility.list("m1", "make", "x", this.getTestClassPath() + ".ConstructorThrows", "thrown message"));
        this.assertExceptionReturned("thrown message", "m1");
    }

    @Test
    public void oneFunctionCall() throws Exception {
        this.statements.add(ListUtility.list("id", "call", "testSlim", "returnString"));
        this.respondsWith(ListUtility.list(ListUtility.list("id", "string")));
    }

    @Test
    public void oneFunctionCallWithBlankArgument() throws Exception {
        this.statements.add(ListUtility.list("id", "call", "testSlim", "echoString", ""));
        this.respondsWith(ListUtility.list(ListUtility.list("id", "")));
    }

    @Test
    public void oneFunctionCallToShowThatLaterImportsTakePrecedence() throws Exception {
        this.statements.add(0, ListUtility.list("i2", "import", this.getTestClassPath() + ".testSlimInThisPackageShouldNotBeTheOneUsed"));
        this.statements.add(ListUtility.list("id", "call", "testSlim", "returnString"));
        this.expectedResults.add(0, ListUtility.list("i2", "OK"));
        this.respondsWith(ListUtility.list(ListUtility.list("id", "string")));
    }

    @Test
    public void canPassArgumentsToConstructor() throws Exception {
        this.statements.add(ListUtility.list("m2", "make", "testSlim2", this.testClass, "3"));
        this.statements.add(ListUtility.list("c1", "call", "testSlim2", "returnConstructorArg"));
        this.statements.add(ListUtility.list("c2", "call", "testSlim", "returnConstructorArg"));
        this.respondsWith(ListUtility.list(ListUtility.list("m2", "OK"), ListUtility.list("c1", "3"), ListUtility.list("c2", "0")));
    }

    @Test
    public void multiFunctionCall() throws Exception {
        this.statements.add(ListUtility.list("id1", "call", "testSlim", "addTo", "1", "2"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "addTo", "3", "4"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "3"), ListUtility.list("id2", "7")));
    }

    @Test
    public void callAndAssign() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "addTo", "5", "6"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "echoInt", "$v"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "11"), ListUtility.list("id2", "11")));
    }

    @Test
    public void canReplaceMultipleSymbolsInAnArgument() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v1", "testSlim", "echoString", "Bob"));
        this.statements.add(ListUtility.list("id2", "callAndAssign", "v2", "testSlim", "echoString", "Martin"));
        this.statements.add(ListUtility.list("id3", "call", "testSlim", "echoString", "name: $v1 $v2"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "Bob"), ListUtility.list("id2", "Martin"), ListUtility.list("id3", "name: Bob Martin")));
    }

    @Test
    public void canReplaceMultipleSymbolsInAnArgumentWhenOneVarIsPrefixOfAnother() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "echoString", "Bob"));
        this.statements.add(ListUtility.list("id2", "callAndAssign", "v1", "testSlim", "echoString", "Martin"));
        this.statements.add(ListUtility.list("id3", "call", "testSlim", "echoString", "name: $v $v1"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "Bob"), ListUtility.list("id2", "Martin"), ListUtility.list("id3", "name: Bob Martin")));
    }

    @Test
    public void canReplaceSymbolWhenValueIsNull() throws Exception {
        this.statements.add(ListUtility.list("id1", "make", "nf", "NullFixture"));
        this.statements.add(ListUtility.list("id2", "callAndAssign", "v", "nf", "getNull"));
        this.statements.add(ListUtility.list("id3", "call", "testSlim", "echoString", "$v"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "OK"), ListUtility.list("id2", null), ListUtility.list("id3", null)));
    }

    @Test
    public void passAndReturnList() throws Exception {
        List<String> l = ListUtility.list("one", "two");
        this.statements.add(ListUtility.list("id", "call", "testSlim", "echoList", l));
        this.respondsWith(ListUtility.list(ListUtility.list("id", l)));
    }

    @Test
    public void passAndReturnListWithVariable() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "addTo", "3", "4"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "echoList", ListUtility.list("$v")));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "7"), ListUtility.list("id2", ListUtility.list(7))));
    }

    @Test
    public void callToVoidFunctionReturnsVoidValue() throws Exception {
        this.statements.add(ListUtility.list("id", "call", "testSlim", "voidFunction"));
        this.respondsWith(ListUtility.list(ListUtility.list("id", "/__VOID__/")));
    }

    @Test
    public void callToFunctionReturningNull() throws Exception {
        this.statements.add(ListUtility.list("id", "call", "testSlim", "nullString"));
        this.respondsWith(ListUtility.list(ListUtility.list("id", null)));
    }

    @Test
    public void fixtureChainingWithAssignmentFromFactory() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "createTestSlimWithString", "test string"));
        this.statements.add(ListUtility.list("m2", "make", "chainedTestSlim", "$v"));
        this.statements.add(ListUtility.list("id2", "call", "chainedTestSlim", "getStringArg"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "TestSlim: 0, test string"), ListUtility.list("m2", "OK"), ListUtility.list("id2", "test string")));
    }

    @Test
    public void methodAcceptsTestSlimFromSymbol() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "createTestSlimWithString", "test string"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "getStringFromOther", "$v"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "TestSlim: 0, test string"), ListUtility.list("id2", "test string")));
    }

    @Test
    public void methodAcceptsObjectFromSymbol() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "createTestSlimWithString", "test string"));
        this.statements.add(ListUtility.list("id2", "call", "testSlim", "isSame", "$v"));
        this.statements.add(ListUtility.list("m2", "make", "chainedTestSlim", "$v"));
        this.statements.add(ListUtility.list("id3", "call", "chainedTestSlim", "isSame", "$v"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "TestSlim: 0, test string"), ListUtility.list("id2", "false"), ListUtility.list("m2", "OK"), ListUtility.list("id3", "true")));
    }

    @Test
    public void constructorAcceptsTestSlimFromSymbol() throws Exception {
        this.statements.add(ListUtility.list("id1", "callAndAssign", "v", "testSlim", "createTestSlimWithString", "test string"));
        this.statements.add(ListUtility.list("m2", "make", "newTestSlim", this.testClass, "4", "$v"));
        this.statements.add(ListUtility.list("id2", "call", "newTestSlim", "getStringArg"));
        this.respondsWith(ListUtility.list(ListUtility.list("id1", "TestSlim: 0, test string"), ListUtility.list("m2", "OK"), ListUtility.list("id2", "test string")));
    }
}

