/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.StatementExecutorInterface;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SlimInstanceCreationTestBase {
    protected StatementExecutorInterface caller;
    protected String testClass = "TestSlim";

    @Before
    public abstract void setUp() throws Exception;

    protected abstract void assertInstanceOfTestSlim(Object var1);

    protected abstract String getTestClassPath();

    protected String getTestClassName() {
        return this.getTestClassPath() + "." + this.testClass;
    }

    @Test
    public void canCreateInstance() throws Exception {
        Object response = this.caller.create("x", this.getTestClassName(), new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)response);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test
    public void canCreateInstanceWhenSpecifiedBySymbol() throws Exception {
        this.caller.setVariable("X", this.getTestClassName());
        Object response = this.caller.create("x", "$X", new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)response);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test
    public void canSetActorFromInstanceStoredInSymbol() throws Exception {
        Object response = this.caller.create("x", this.getTestClassName(), new Object[0]);
        Object x = this.caller.getInstance("x");
        this.caller.setVariable("X", x);
        response = this.caller.create("y", "$X", new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)response);
        Object y = this.caller.getInstance("y");
        Assert.assertEquals((Object)x, (Object)y);
    }

    @Test
    public void canCreateInstanceWithArguments() throws Exception {
        Object response = this.caller.create("x", this.getTestClassName(), new Object[]{"3"});
        Assert.assertEquals((Object)"OK", (Object)response);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test
    public void cantCreateInstanceIfConstructorArgumentBad() throws Exception {
        String result = (String)this.caller.create("x", this.getTestClassName(), new Object[]{"notInt"});
        this.assertException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR " + this.getTestClassName() + "[1]", result);
    }

    @Test
    public void cantCreateInstanceIfConstructorArgumentCountIncorrect() throws Exception {
        String result = (String)this.caller.create("x", this.getTestClassName(), new Object[]{"3", "4"});
        this.assertException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR " + this.getTestClassName() + "[2]>>", result);
    }

    @Test
    public void throwsInstanceNotCreatedErrorIfNoSuchClass() throws Exception {
        String result = (String)this.caller.create("x", this.getTestClassPath() + ".NoSuchClass", new Object[0]);
        this.assertException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR " + this.getTestClassPath() + ".NoSuchClass[0]>>", result);
    }

    @Test
    public void throwsInstanceNotCreatedErrorIfNoPublicDefaultConstructor() throws Exception {
        String result = (String)this.caller.create("x", this.getTestClassPath() + ".ClassWithNoPublicDefaultConstructor", new Object[0]);
        this.assertException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR " + this.getTestClassPath() + ".ClassWithNoPublicDefaultConstructor[0]>>", result);
    }

    @Test
    public void canAddPath() {
        this.caller.addPath(this.getTestClassPath());
        Object response = this.caller.create("x", this.testClass, new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)response);
        Object x = this.caller.getInstance("x");
        this.assertInstanceOfTestSlim(x);
    }

    @Test
    public void cantCreateInstanceWithoutPath() {
        String result = (String)this.caller.create("x", this.testClass, new Object[0]);
        this.assertException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR " + this.testClass + "[0]>>", result);
    }

    protected void assertException(String message, String result) {
        Assert.assertTrue((String)result, (result.indexOf("__EXCEPTION__:") != -1 && result.indexOf(message) != -1 ? 1 : 0) != 0);
    }
}

