/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Evaluator;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Matchable;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Table;
import fitnesse.wikitext.parser.Variable;
import util.Maybe;

public class PlainTextTable
extends SymbolType
implements Rule {
    private static final SymbolType[] terminators = new SymbolType[]{SymbolType.PlainTextCellSeparator, SymbolType.Newline, SymbolType.ClosePlainTextTable};

    public PlainTextTable() {
        super("PlainTextTable");
        this.wikiMatcher(new Matcher().startLine().string("!["));
        this.wikiRule(this);
        this.htmlTranslation(new Table());
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        SymbolProvider plainTextTableTypes;
        Symbol table = parser.getCurrent();
        table.putProperty("class", "plain_text_table");
        parser.moveNext(1);
        if (parser.atEnd()) {
            return Symbol.nothing;
        }
        if (!parser.getCurrent().isType(SymbolType.Newline) && !parser.getCurrent().isType(SymbolType.Whitespace)) {
            ColumnSeparator columnSeparator = new ColumnSeparator(parser.getCurrent().getContent().substring(0, 1));
            plainTextTableTypes = new SymbolProvider(new SymbolType[]{SymbolType.Newline, SymbolType.ClosePlainTextTable, Evaluator.symbolType, Literal.symbolType, Variable.symbolType});
            plainTextTableTypes.addMatcher(columnSeparator);
            parser.moveNext(1);
            if (parser.atEnd()) {
                return Symbol.nothing;
            }
        } else {
            plainTextTableTypes = new SymbolProvider(new SymbolType[]{SymbolType.Newline, SymbolType.ClosePlainTextTable, Evaluator.symbolType, Literal.symbolType, Variable.symbolType});
        }
        if (parser.getCurrent().isType(SymbolType.Whitespace)) {
            table.putProperty("hideFirst", "");
        }
        Symbol row = null;
        while (true) {
            Symbol line = parser.parseToWithSymbols(terminators, plainTextTableTypes, 0);
            if (parser.atEnd()) {
                return Symbol.nothing;
            }
            if (parser.getCurrent().isType(SymbolType.ClosePlainTextTable)) {
                return new Maybe<Symbol>(table);
            }
            if (row == null) {
                row = new Symbol(SymbolType.SymbolList);
                table.add(row);
            }
            row.add(line);
            if (!parser.getCurrent().isType(SymbolType.Newline)) continue;
            row = null;
        }
    }

    private class ColumnSeparator
    implements Matchable {
        private Matcher matcher;

        public ColumnSeparator(String separator) {
            this.matcher = new Matcher().string(separator);
        }

        @Override
        public boolean matchesFor(SymbolType symbolType) {
            return symbolType == SymbolType.PlainTextCellSeparator;
        }

        @Override
        public SymbolMatch makeMatch(ScanString input) {
            Maybe<Integer> matchLength = this.matcher.makeMatch(input);
            return matchLength.isNothing() ? SymbolMatch.noMatch : new SymbolMatch(SymbolType.PlainTextCellSeparator, input, matchLength.getValue());
        }
    }
}

