/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

public class Variable
extends SymbolType
implements Rule,
Translation {
    public static final Variable symbolType = new Variable();

    public Variable() {
        super("Variable");
        this.wikiMatcher(new Matcher().string("${"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String name = parser.parseToAsString(SymbolType.CloseBrace);
        if (parser.atEnd() || name.length() == 0) {
            return Symbol.nothing;
        }
        if (!ScanString.isVariableName(name)) {
            return Symbol.nothing;
        }
        current.add(name);
        Maybe<String> variableValue = parser.getVariableSource().findVariable(name);
        if (variableValue.isNothing()) {
            current.add(new Symbol(SymbolType.Meta).add("undefined variable: " + name));
        } else {
            Symbol variableValueSymbol = parser.parseWithParent(variableValue.getValue(), null);
            current.add(variableValueSymbol);
        }
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        return translator.translate(symbol.childAt(1));
    }
}

