/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.nio.ByteBuffer;

public class SimpleResponse
extends Response {
    private byte[] content = new byte[0];

    public SimpleResponse() {
        super("html");
    }

    public SimpleResponse(int status) {
        super("html", status);
    }

    @Override
    public void readyToSend(ResponseSender sender) throws Exception {
        byte[] bytes = this.getBytes();
        sender.send(bytes);
        sender.close();
    }

    public void setContent(String value) throws Exception {
        this.content = this.getEncodedBytes(value);
    }

    public void setContent(byte[] value) {
        this.content = value;
    }

    public String toString() {
        return String.format("status = %s,  contentType = %s, content = %s", this.getStatus(), this.getContentType(), this.getContent());
    }

    public String getContent() {
        return new String(this.content);
    }

    public byte[] getContentBytes() {
        return this.content;
    }

    public String getText() {
        return new String(this.getBytes());
    }

    public byte[] getBytes() {
        this.addStandardHeaders();
        byte[] headerBytes = this.makeHttpHeaders().getBytes();
        ByteBuffer bytes = ByteBuffer.allocate(headerBytes.length + this.getContentSize());
        bytes.put(headerBytes).put(this.content);
        return bytes.array();
    }

    @Override
    public int getContentSize() {
        return this.content.length;
    }

    @Override
    protected void addSpecificHeaders() {
        this.addHeader("Content-Length", String.valueOf(this.getContentSize()));
    }
}

