/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.JUnitHelper;
import fitnesse.junit.JUnitRunNotifierResultsListener;
import fitnesse.responders.run.JavaFormatter;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class FitNesseSuite
extends ParentRunner<String> {
    private final Class<?> suiteClass;
    private final String suiteName;
    private String fitNesseDir;
    private String outputDir;
    private String suiteFilter;
    private String excludeSuiteFilter;
    private boolean debugMode = false;
    private int port = 0;

    public FitNesseSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        super(suiteClass);
        this.suiteClass = suiteClass;
        this.suiteName = FitNesseSuite.getSuiteName(suiteClass);
        this.fitNesseDir = FitNesseSuite.getFitnesseDir(suiteClass);
        this.outputDir = FitNesseSuite.getOutputDir(suiteClass);
        this.suiteFilter = FitNesseSuite.getSuiteFilter(suiteClass);
        this.excludeSuiteFilter = FitNesseSuite.getExcludeSuiteFilter(suiteClass);
        this.debugMode = FitNesseSuite.useDebugMode(suiteClass);
        this.port = FitNesseSuite.getPort(suiteClass);
    }

    protected Description describeChild(String child) {
        return Description.createTestDescription(this.suiteClass, (String)child);
    }

    protected List<String> getChildren() {
        return JavaFormatter.getInstance(this.suiteName).getTestsExecuted();
    }

    static String getFitnesseDir(Class<?> klass) throws InitializationError {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        if (fitnesseDirAnnotation == null) {
            throw new InitializationError("There must be a @FitnesseDir annotation");
        }
        return fitnesseDirAnnotation.value();
    }

    static String getSuiteFilter(Class<?> klass) throws InitializationError {
        SuiteFilter suiteFilterAnnotation = klass.getAnnotation(SuiteFilter.class);
        if (suiteFilterAnnotation == null) {
            return null;
        }
        return suiteFilterAnnotation.value();
    }

    static String getExcludeSuiteFilter(Class<?> klass) throws InitializationError {
        ExcludeSuiteFilter excludeSuiteFilterAnnotation = klass.getAnnotation(ExcludeSuiteFilter.class);
        if (excludeSuiteFilterAnnotation == null) {
            return null;
        }
        return excludeSuiteFilterAnnotation.value();
    }

    static String getSuiteName(Class<?> klass) throws InitializationError {
        Name nameAnnotation = klass.getAnnotation(Name.class);
        if (nameAnnotation == null) {
            throw new InitializationError("There must be a @Name annotation");
        }
        return nameAnnotation.value();
    }

    static String getOutputDir(Class<?> klass) throws InitializationError {
        OutputDir outputDirAnnotation = klass.getAnnotation(OutputDir.class);
        if (outputDirAnnotation == null) {
            throw new InitializationError("There must be a @OutputDir annotation");
        }
        if (!"".equals(outputDirAnnotation.value())) {
            return outputDirAnnotation.value();
        }
        if (!"".equals(outputDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(outputDirAnnotation.systemProperty());
            File outputDir = new File(baseDir, outputDirAnnotation.pathExtension());
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @OutputDir you have to specify either 'value' or 'systemProperty'");
    }

    public static boolean useDebugMode(Class<?> klass) {
        DebugMode debugModeAnnotation = klass.getAnnotation(DebugMode.class);
        if (null == debugModeAnnotation) {
            return true;
        }
        return debugModeAnnotation.value();
    }

    public static int getPort(Class<?> klass) {
        Port portAnnotation = klass.getAnnotation(Port.class);
        if (null == portAnnotation) {
            return 0;
        }
        int lport = portAnnotation.value();
        if (!"".equals(portAnnotation.systemProperty())) {
            lport = Integer.getInteger(portAnnotation.systemProperty(), lport);
        }
        return lport;
    }

    public void run(RunNotifier notifier) {
        JUnitHelper helper = this.createJUnitHelper(notifier);
        try {
            helper.assertSuitePasses(this.suiteName, this.suiteFilter, this.excludeSuiteFilter);
        }
        catch (AssertionFailedError e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
    }

    protected void runChild(String test, RunNotifier notifier) {
        JUnitHelper helper = this.createJUnitHelper(notifier);
        try {
            helper.assertTestPasses(this.suiteName);
        }
        catch (AssertionFailedError e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
    }

    private JUnitHelper createJUnitHelper(RunNotifier notifier) {
        JUnitHelper jUnitHelper = new JUnitHelper(this.fitNesseDir, this.outputDir, new JUnitRunNotifierResultsListener(notifier, this.suiteClass));
        jUnitHelper.setDebugMode(this.debugMode);
        jUnitHelper.setPort(this.port);
        return jUnitHelper;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Port {
        public int value() default 0;

        public String systemProperty() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OutputDir {
        public String value() default "";

        public String systemProperty() default "";

        public String pathExtension() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FitnesseDir {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ExcludeSuiteFilter {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuiteFilter {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DebugMode {
        public boolean value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Name {
        public String value();
    }
}

