/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.CompositeExecutionLog;
import fitnesse.responders.run.FitTestSystem;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.responders.run.slimResponder.HtmlSlimTestSystem;
import fitnesse.wiki.WikiPage;
import java.util.HashMap;
import java.util.Map;

public class TestSystemGroup {
    private Map<TestSystem.Descriptor, TestSystem> testSystems = new HashMap<TestSystem.Descriptor, TestSystem>();
    private FitNesseContext context;
    private WikiPage page;
    private TestSystemListener testSystemListener;
    private CompositeExecutionLog log;
    private boolean fastTest = false;
    private boolean manualStart = false;

    public TestSystemGroup(FitNesseContext context, WikiPage page, TestSystemListener listener) throws Exception {
        this.context = context;
        this.page = page;
        this.testSystemListener = listener;
        this.log = new CompositeExecutionLog(page);
    }

    public CompositeExecutionLog getExecutionLog() throws Exception {
        return this.log;
    }

    public void bye() throws Exception {
        for (TestSystem testSystem : this.testSystems.values()) {
            testSystem.bye();
        }
    }

    public void kill() throws Exception {
        for (TestSystem testSystem : this.testSystems.values()) {
            testSystem.kill();
        }
    }

    public void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    public void setManualStart(boolean manualStart) {
        this.manualStart = manualStart;
    }

    public boolean isSuccessfullyStarted() {
        for (TestSystem testSystem : this.testSystems.values()) {
            if (testSystem.isSuccessfullyStarted()) continue;
            return false;
        }
        return true;
    }

    TestSystem startTestSystem(TestSystem.Descriptor descriptor, String classPath) throws Exception {
        TestSystem testSystem = null;
        if (!this.testSystems.containsKey(descriptor)) {
            testSystem = this.makeTestSystem(descriptor);
            testSystem.setFastTest(this.fastTest);
            testSystem.setManualStart(this.manualStart);
            this.testSystems.put(descriptor, testSystem);
            this.log.add(descriptor.testSystemName, testSystem.getExecutionLog(classPath, descriptor));
            testSystem.start();
        }
        return testSystem;
    }

    private TestSystem makeTestSystem(TestSystem.Descriptor descriptor) throws Exception {
        if ("slim".equalsIgnoreCase(TestSystem.getTestSystemType(descriptor.testSystemName))) {
            return new HtmlSlimTestSystem(this.page, this.testSystemListener);
        }
        return new FitTestSystem(this.context, this.page, this.testSystemListener);
    }
}

