/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.run.formatters.SuiteExecutionReportFormatter;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.responders.testHistory.TestResultRecord;
import fitnesse.wiki.WikiPage;
import java.io.Writer;
import java.util.Date;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import util.TimeMeasurement;

public class CachingSuiteXmlFormatter
extends SuiteExecutionReportFormatter {
    private TestHistory testHistory = new TestHistory();
    private VelocityContext velocityContext = new VelocityContext();
    private VelocityEngine velocityEngine = VelocityFactory.getVelocityEngine();
    private Writer writer;
    private boolean includeHtml = false;

    public CachingSuiteXmlFormatter(FitNesseContext context, WikiPage page, Writer writer) throws Exception {
        super(context, page);
        this.writer = writer;
    }

    void setTestHistoryForTests(TestHistory testHistory) {
        this.testHistory = testHistory;
    }

    void setVelocityForTests(VelocityContext velocityContext, VelocityEngine engine, Writer writer) {
        this.velocityContext = velocityContext;
        this.velocityEngine = engine;
        this.writer = writer;
    }

    @Override
    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws Exception {
        super.allTestingComplete(totalTimeMeasurement);
        this.writeOutSuiteXML();
    }

    protected void writeOutSuiteXML() throws Exception {
        this.testHistory.readHistoryDirectory(this.context.getTestHistoryDirectory());
        this.velocityContext.put("formatter", this);
        Template template = this.velocityEngine.getTemplate("suiteXML.vm");
        template.merge(this.velocityContext, this.writer);
        this.writer.close();
    }

    public TestExecutionReport getTestExecutionReport(SuiteExecutionReport.PageHistoryReference reference) throws Exception {
        PageHistory pageHistory = this.testHistory.getPageHistory(reference.getPageName());
        Date date = new Date(reference.getTime());
        TestResultRecord record = pageHistory.get(date);
        return this.makeTestExecutionReport().read(record.getFile());
    }

    TestExecutionReport makeTestExecutionReport() {
        return new TestExecutionReport();
    }

    public void includeHtml() {
        this.includeHtml = true;
    }

    public boolean shouldIncludeHtml() {
        return this.includeHtml;
    }

    public long getTotalRunTimeInMillis() {
        return this.suiteExecutionReport.getTotalRunTimeInMillis();
    }
}

