/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.responders.testHistory.TestHistory;
import java.io.File;
import org.apache.velocity.VelocityContext;

public class TestHistoryResponder
implements SecureResponder {
    private File resultsDirectory;
    private boolean generateNullResponseForTest;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        if (this.resultsDirectory == null) {
            this.resultsDirectory = context.getTestHistoryDirectory();
        }
        SimpleResponse response = new SimpleResponse();
        if (!this.generateNullResponseForTest) {
            TestHistory history = new TestHistory();
            String pageName = request.getResource();
            history.readPageHistoryDirectory(this.resultsDirectory, pageName);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("pageTitle", new PageTitle(this.makePageTitle(pageName)));
            velocityContext.put("testHistory", history);
            String velocityTemplate = "testHistory.vm";
            if (this.formatIsXML(request)) {
                response.setContentType("text/xml");
                velocityTemplate = "testHistoryXML.vm";
            }
            response.setContent(VelocityFactory.translateTemplate(velocityContext, velocityTemplate));
        }
        return response;
    }

    private String makePageTitle(String pageName) {
        return "".equals(pageName) ? "Test History" : "Test History for " + pageName;
    }

    private boolean formatIsXML(Request request) {
        return request.getInput("format") != null && request.getInput("format").toString().toLowerCase().equals("xml");
    }

    public void setResultsDirectory(File resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public File getResultsDirectory() {
        return this.resultsDirectory;
    }

    public void generateNullResponseForTest() {
        this.generateNullResponseForTest = true;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

