/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.FitNesseContext;
import fitnesse.wikitext.parser.SourcePage;
import java.util.HashMap;
import util.Maybe;

public class ParsingPage {
    private SourcePage page;
    private SourcePage namedPage;
    private HashMap<String, HashMap<String, Maybe<String>>> cache;

    public ParsingPage(SourcePage page) {
        this(page, page, new HashMap<String, HashMap<String, Maybe<String>>>());
    }

    public ParsingPage copyForPage(SourcePage page) {
        return new ParsingPage(page, page, this.cache);
    }

    public ParsingPage copyForNamedPage(SourcePage namedPage) {
        return new ParsingPage(this.page, namedPage, this.cache);
    }

    private ParsingPage(SourcePage page, SourcePage namedPage, HashMap<String, HashMap<String, Maybe<String>>> cache) {
        this.page = page;
        this.namedPage = namedPage;
        this.cache = cache;
    }

    public SourcePage getPage() {
        return this.page;
    }

    public SourcePage getNamedPage() {
        return this.namedPage;
    }

    public Maybe<String> getSpecialVariableValue(String key) {
        String value;
        if (key.equals("RUNNING_PAGE_NAME")) {
            value = this.page.getName();
        } else if (key.equals("RUNNING_PAGE_PATH")) {
            value = this.page.getPath();
        } else if (key.equals("PAGE_NAME")) {
            value = this.namedPage.getName();
        } else if (key.equals("PAGE_PATH")) {
            value = this.namedPage.getPath();
        } else if (key.equals("FITNESSE_PORT")) {
            value = Integer.toString(FitNesseContext.globalContext.port);
        } else if (key.equals("FITNESSE_ROOTPATH")) {
            value = FitNesseContext.globalContext.rootPath;
        } else {
            return Maybe.noString;
        }
        return new Maybe<String>(value);
    }

    public boolean inCache(SourcePage page) {
        return this.cache.containsKey(page.getFullName());
    }

    public Maybe<String> findVariable(SourcePage page, String name) {
        String key = page.getFullName();
        if (!this.cache.containsKey(key)) {
            return Maybe.noString;
        }
        if (!this.cache.get(key).containsKey(name)) {
            return Maybe.noString;
        }
        return this.cache.get(key).get(name);
    }

    public Maybe<String> findVariable(String name) {
        return this.findVariable(this.page, name);
    }

    public String findVariable(SourcePage page, String name, String defaultValue) {
        Maybe<String> result = this.findVariable(page, name);
        return result.isNothing() ? defaultValue : result.getValue();
    }

    public void putVariable(SourcePage page, String name, Maybe<String> value) {
        String key = page.getFullName();
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new HashMap());
        }
        this.cache.get(key).put(name, value);
    }

    public void putVariable(String name, String value) {
        this.putVariable(this.page, name, new Maybe<String>(value));
    }
}

