/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSType;

public class GDSSynchronizationPolicy {
    public static GDS applySyncronizationPolicy(GDS gds, GDSType gdsType) {
        String osName;
        ClientLibrarySyncPolicy syncPolicy = null;
        if (gdsType == GDSType.NATIVE_LOCAL) {
            syncPolicy = new ClientLibrarySyncPolicy(gds);
        }
        if (gdsType == GDSType.NATIVE_EMBEDDED && (osName = System.getProperty("os.name")) != null && osName.indexOf("Windows") == -1) {
            syncPolicy = new ClientLibrarySyncPolicy(gds);
        }
        if (syncPolicy == null) {
            return gds;
        }
        GDS wrappedObject = (GDS)Proxy.newProxyInstance(gds.getClass().getClassLoader(), GDSSynchronizationPolicy.getAllInterfaces(gds.getClass()), (InvocationHandler)syncPolicy);
        return wrappedObject;
    }

    private static Class[] getAllInterfaces(Class clazz) {
        HashSet result = new HashSet();
        do {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                result.add(interfaces[i]);
            }
        } while ((clazz = clazz.getSuperclass()).getSuperclass() != null);
        return result.toArray(new Class[result.size()]);
    }

    private static class ClientLibrarySyncPolicy
    extends AbstractSynchronizationPolicy {
        public static final Object SYNC_OBJECT = new Object();

        public ClientLibrarySyncPolicy(GDS gds) {
            super(gds);
        }

        protected Object getSynchronizationObject() {
            return SYNC_OBJECT;
        }
    }

    private static abstract class AbstractSynchronizationPolicy
    implements InvocationHandler {
        private GDS gds;

        protected AbstractSynchronizationPolicy(GDS gds) {
            this.gds = gds;
        }

        protected GDS getGds() {
            return this.gds;
        }

        protected abstract Object getSynchronizationObject();

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object syncObject;
            Object object = syncObject = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    return method.invoke((Object)this.gds, args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        }
    }
}

