/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSavepoint;

public class FBConnection
extends AbstractConnection {
    private int savepointCounter = 0;
    private LinkedList savepoints = new LinkedList();

    public FBConnection(FBManagedConnection mc) {
        super(mc);
    }

    public synchronized void commit() throws SQLException {
        super.commit();
        this.invalidateSavepoints();
    }

    public synchronized void rollback() throws SQLException {
        super.rollback();
        this.invalidateSavepoints();
    }

    public synchronized Statement createStatement(int param1, int param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String param1, int param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String param1, int param2, int param3, int param4) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String param1, int[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized PreparedStatement prepareStatement(String param1, String[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public synchronized void setHoldability(int param1) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public synchronized CallableStatement prepareCall(String param1, int param2, int param3, int param4) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    private int getNextSavepointCounter() {
        return this.savepointCounter++;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        FBSavepoint savepoint = new FBSavepoint(this.getNextSavepointCounter());
        this.setSavepoint(savepoint);
        this.savepoints.addLast(savepoint);
        return savepoint;
    }

    private void setSavepoint(FBSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.");
        }
        try {
            this.ensureInTransaction();
            this.mc.executeImmediate("SAVEPOINT " + savepoint.getServerSavepointId());
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        FBSavepoint savepoint = new FBSavepoint(name);
        this.setSavepoint(savepoint);
        return savepoint;
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.");
        }
        if (!(savepoint instanceof FBSavepoint)) {
            throw new SQLException("Specified savepoint was not obtained from this connection.");
        }
        FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
        if (!fbSavepoint.isValid()) {
            throw new SQLException("Savepoint is no longer valid.");
        }
        try {
            this.mc.executeImmediate("ROLLBACK TO " + fbSavepoint.getServerSavepointId());
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.");
        }
        if (!(savepoint instanceof FBSavepoint)) {
            throw new SQLException("Specified savepoint was not obtained from this connection.");
        }
        FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
        if (!fbSavepoint.isValid()) {
            throw new SQLException("Savepoint is no longer valid.");
        }
        try {
            this.mc.executeImmediate("RELEASE SAVEPOINT " + fbSavepoint.getServerSavepointId() + " ONLY");
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        fbSavepoint.invalidate();
        this.savepoints.remove(fbSavepoint);
    }

    private synchronized void invalidateSavepoints() {
        Iterator iter = this.savepoints.iterator();
        while (iter.hasNext()) {
            ((FBSavepoint)iter.next()).invalidate();
        }
        this.savepoints.clear();
    }
}

