/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class Accessor {
    static final int FIXED_CHAR = 999;
    static final int CHAR = 96;
    static final int VARCHAR = 1;
    static final int VCS = 9;
    static final int LONG = 8;
    static final int NUMBER = 2;
    static final int VARNUM = 6;
    static final int BINARY_FLOAT = 100;
    static final int BINARY_DOUBLE = 101;
    static final int RAW = 23;
    static final int VBI = 15;
    static final int LONG_RAW = 24;
    static final int ROWID = 104;
    static final int ROWID_THIN = 11;
    static final int RESULT_SET = 102;
    static final int RSET = 116;
    static final int DATE = 12;
    static final int BLOB = 113;
    static final int CLOB = 112;
    static final int BFILE = 114;
    static final int NAMED_TYPE = 109;
    static final int REF_TYPE = 111;
    static final int TIMESTAMP = 180;
    static final int TIMESTAMPTZ = 181;
    static final int TIMESTAMPLTZ = 231;
    static final int INTERVALYM = 182;
    static final int INTERVALDS = 183;
    static final int UROWID = 208;
    static final int PLSQL_INDEX_TABLE = 998;
    static final int T2S_OVERLONG_RAW = 997;
    static final int SET_CHAR_BYTES = 996;
    static final int NULL_TYPE = 995;
    static final int ONLY_FORM_USABLE = 0;
    static final int NOT_USABLE = 1;
    static final int NO_NEED_TO_PREPARE = 2;
    static final int NEED_TO_PREPARE = 3;
    OracleStatement stmt;
    boolean outBind;
    int t_type;
    int t_max_length;
    boolean is_stream = false;
    boolean isColumnNumberAware = false;
    short formOfUse = (short)2;
    OracleType t_otype;
    int external_type;
    String t_typeName;
    String columnName;
    int c_type;
    int c_max_length;
    boolean nullable;
    int precision;
    int scale;
    int flags;
    int contflag;
    int total_elems;
    OracleType c_otype;
    String c_typeName;
    int definedColumnType = 0;
    int definedColumnSize = 0;
    int oacmxl = 0;
    byte[] rowSpaceByte = null;
    char[] rowSpaceChar = null;
    short[] rowSpaceIndicator = null;
    int columnIndex = 0;
    int lengthIndex = 0;
    int indicatorIndex = 0;
    int byteLength = 0;
    int charLength = 0;
    int d_type;
    int lastRowProcessed = 0;
    boolean isUseLess = false;
    int physicalColumnIndex = -2;
    boolean isNullByDescribe = false;

    Accessor() {
    }

    void setOffsets(int n) {
        this.columnIndex = this.stmt.defineByteSubRange;
        this.stmt.defineByteSubRange = this.columnIndex + n * this.byteLength;
    }

    void init(OracleStatement oracleStatement, int n, int n2, short s, boolean bl) throws SQLException {
        this.stmt = oracleStatement;
        this.outBind = bl;
        this.t_type = n;
        this.d_type = n2;
        this.formOfUse = s;
    }

    abstract void initForDataAccess(int var1, int var2, String var3) throws SQLException;

    void initForDescribe(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s) throws SQLException {
        this.c_type = n;
        this.c_max_length = n2;
        this.nullable = bl;
        this.precision = n4;
        this.scale = n5;
        this.flags = n3;
        this.contflag = n6;
        this.total_elems = n7;
        this.formOfUse = s;
    }

    void initForDescribe(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s, String string) throws SQLException {
        this.c_typeName = string;
        this.c_otype = null;
        this.initForDescribe(n, n2, bl, n3, n4, n5, n6, n7, s);
    }

    OracleInputStream initForNewRow() throws SQLException {
        this.unimpl("initForNewRow");
        return null;
    }

    int useForDataAccessIfPossible(int n, int n2, int n3, String string) throws SQLException {
        int n4 = 3;
        int n5 = 0;
        int n6 = 0;
        if (this.t_type != 0) {
            if (this.t_type != n) {
                n4 = 0;
            } else if (this.rowSpaceIndicator != null) {
                n5 = this.byteLength;
                n6 = this.charLength;
            }
        }
        if (n4 == 3) {
            this.initForDataAccess(n2, n3, string);
            if (!this.outBind && n5 >= this.byteLength && n6 >= this.charLength) {
                n4 = 2;
            }
        }
        return n4;
    }

    boolean useForDescribeIfPossible(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s, String string) throws SQLException {
        this.initForDescribe(n, n2, bl, n3, n4, n5, n6, n7, s, string);
        return true;
    }

    String getColumnName() {
        return this.columnName;
    }

    void setFormOfUse(short s) {
        this.formOfUse = s;
    }

    void updateColumnNumber(int n) {
    }

    public String toString() {
        return super.toString() + ", stmt=" + this.stmt + ", outBind=" + this.outBind + ", t_type=" + this.t_type + ", t_max_length=" + this.t_max_length + ", is_stream=" + this.is_stream + ", formOfUse=" + this.formOfUse + ", t_otype=" + this.t_otype + ", external_type=" + this.external_type + ", t_typeName=" + this.t_typeName + ", columnName=" + this.columnName + ", c_type=" + this.c_type + ", c_max_length=" + this.c_max_length + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", c_otype=" + this.c_otype + ", c_typeName=" + this.c_typeName + ", rowSpaceByte=" + this.rowSpaceByte + ", rowSpaceChar=" + this.rowSpaceChar + ", rowSpaceIndicator=" + this.rowSpaceIndicator + ", columnIndex=" + this.columnIndex + ", lengthIndex=" + this.lengthIndex + ", indicatorIndex=" + this.indicatorIndex + ", byteLength=" + this.byteLength + ", charLength=" + this.charLength;
    }

    void unimpl(String string) throws SQLException {
        DatabaseError.throwSqlException(4, string + " not implemented for " + this.getClass());
    }

    boolean getBoolean(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return false;
        }
        this.unimpl("getBoolean");
        return false;
    }

    byte getByte(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0;
        }
        this.unimpl("getByte");
        return 0;
    }

    short getShort(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0;
        }
        this.unimpl("getShort");
        return 0;
    }

    int getInt(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0;
        }
        this.unimpl("getInt");
        return 0;
    }

    long getLong(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0L;
        }
        this.unimpl("getLong");
        return 0L;
    }

    float getFloat(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0.0f;
        }
        this.unimpl("getFloat");
        return 0.0f;
    }

    double getDouble(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0.0;
        }
        this.unimpl("getDouble");
        return 0.0;
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getBigDecimal");
        return null;
    }

    BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getBigDecimal");
        return null;
    }

    String getString(int n) throws SQLException {
        return null;
    }

    Date getDate(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getDate");
        return null;
    }

    Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getDate");
        return null;
    }

    Time getTime(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTime");
        return null;
    }

    Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTime");
        return null;
    }

    Timestamp getTimestamp(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTimestamp");
        return null;
    }

    Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTimestamp");
        return null;
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
        }
        return byArray;
    }

    InputStream getAsciiStream(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getAsciiStream");
        return null;
    }

    InputStream getUnicodeStream(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getUnicodeStream");
        return null;
    }

    InputStream getBinaryStream(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getBinaryStream");
        return null;
    }

    Object getObject(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getObject");
        return null;
    }

    Object getAnyDataEmbeddedObject(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getAnyDataEmbeddedObject");
        return null;
    }

    ResultSet getCursor(int n) throws SQLException {
        DatabaseError.throwSqlException(4);
        return null;
    }

    Datum getOracleObject(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getOracleObject");
        return null;
    }

    ROWID getROWID(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        DatabaseError.throwSqlException(4);
        return null;
    }

    NUMBER getNUMBER(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getNUMBER");
        return null;
    }

    DATE getDATE(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getDATE");
        return null;
    }

    ARRAY getARRAY(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getARRAY");
        return null;
    }

    STRUCT getSTRUCT(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getSTRUCT");
        return null;
    }

    OPAQUE getOPAQUE(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getOPAQUE");
        return null;
    }

    REF getREF(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getREF");
        return null;
    }

    CHAR getCHAR(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getCHAR");
        return null;
    }

    RAW getRAW(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getRAW");
        return null;
    }

    BLOB getBLOB(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getBLOB");
        return null;
    }

    CLOB getCLOB(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getCLOB");
        return null;
    }

    BFILE getBFILE(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getBFILE");
        return null;
    }

    CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return customDatumFactory.create(datum, 0);
    }

    ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n);
        return oRADataFactory.create(datum, 0);
    }

    Object getObject(int n, Map map) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getObject");
        return null;
    }

    Reader getCharacterStream(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getCharacterStream");
        return null;
    }

    INTERVALYM getINTERVALYM(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getINTERVALYM");
        return null;
    }

    INTERVALDS getINTERVALDS(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getINTERVALDS");
        return null;
    }

    TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTIMESTAMP");
        return null;
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTIMESTAMPTZ");
        return null;
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getTIMESTAMPLTZ");
        return null;
    }

    URL getURL(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getURL");
        return null;
    }

    Datum[] getOraclePlsqlIndexTable(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        this.unimpl("getOraclePlsqlIndexTable");
        return null;
    }

    boolean isNull(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        return this.rowSpaceIndicator[this.indicatorIndex + n] == -1;
    }

    void setNull(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        this.rowSpaceIndicator[this.indicatorIndex + n] = -1;
    }

    void setStream(InputStream inputStream) throws SQLException {
        this.unimpl("setStream");
    }

    void fetchNextColumns() throws SQLException {
    }

    void calculateSizeTmpByteArray() {
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        DatabaseError.throwSqlException(148);
        return false;
    }

    void copyRow() throws SQLException, IOException {
        DatabaseError.throwSqlException(148);
    }

    int readStream(byte[] byArray, int n) throws SQLException, IOException {
        DatabaseError.throwSqlException(148);
        return -1;
    }

    void initMetadata() throws SQLException {
    }

    void setDisplaySize(int n) throws SQLException {
        this.c_max_length = n;
    }
}

