/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.anchor;

import java.awt.Point;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.anchor.CenterAnchor;
import org.netbeans.modules.visual.anchor.CircularAnchor;
import org.netbeans.modules.visual.anchor.DirectionalAnchor;
import org.netbeans.modules.visual.anchor.FixedAnchor;
import org.netbeans.modules.visual.anchor.FreeRectangularAnchor;
import org.netbeans.modules.visual.anchor.ProxyAnchor;
import org.netbeans.modules.visual.anchor.RectangularAnchor;

public final class AnchorFactory {
    private AnchorFactory() {
    }

    public static Anchor createFixedAnchor(Point location) {
        return new FixedAnchor(location);
    }

    public static Anchor createProxyAnchor(StateModel model, Anchor ... anchors) {
        return model != null && model.getMaxStates() == anchors.length ? new ProxyAnchor(model, anchors) : null;
    }

    public static Anchor createCenterAnchor(Widget widget) {
        return widget != null ? new CenterAnchor(widget) : null;
    }

    public static Anchor createCircularAnchor(Widget widget, int radius) {
        return widget != null && radius >= 0 ? new CircularAnchor(widget, radius) : null;
    }

    public static Anchor createRectangularAnchor(Widget widget) {
        return AnchorFactory.createRectangularAnchor(widget, true);
    }

    public static Anchor createRectangularAnchor(Widget widget, boolean includeBorders) {
        return widget != null ? new RectangularAnchor(widget, includeBorders) : null;
    }

    public static Anchor createDirectionalAnchor(Widget widget, DirectionalAnchorKind kind) {
        return AnchorFactory.createDirectionalAnchor(widget, kind, 0);
    }

    public static Anchor createDirectionalAnchor(Widget widget, DirectionalAnchorKind kind, int gap) {
        return widget != null && kind != null ? new DirectionalAnchor(widget, kind, gap) : null;
    }

    public static Anchor createFreeRectangularAnchor(Widget widget, boolean includeBorders) {
        return widget != null ? new FreeRectangularAnchor(widget, includeBorders) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectionalAnchorKind {
        HORIZONTAL,
        VERTICAL;

    }
}

