/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeConnectionWidget
extends ConnectionWidget {
    private double createSensitivity = 1.0;
    private double deleteSensitivity = 5.0;

    public FreeConnectionWidget(Scene scene) {
        super(scene);
    }

    public FreeConnectionWidget(Scene scene, double createSensitivity, double deleteSensitivity) {
        super(scene);
        this.createSensitivity = createSensitivity;
        this.deleteSensitivity = deleteSensitivity;
    }

    public void addRemoveControlPoint(Point localLocation) {
        ArrayList<Point> list = new ArrayList<Point>(this.getControlPoints());
        if (!this.removeControlPoint(localLocation, list, this.deleteSensitivity)) {
            Point exPoint = null;
            int index = 0;
            for (Point elem : list) {
                Line2D.Double l2d;
                if (exPoint != null && (l2d = new Line2D.Double(exPoint, elem)).ptLineDist(localLocation) < this.createSensitivity) {
                    list.add(index, localLocation);
                    break;
                }
                exPoint = elem;
                ++index;
            }
        }
        this.setControlPoints(list, false);
    }

    private boolean removeControlPoint(Point point, ArrayList<Point> list, double deleteSensitivity) {
        for (Point elem : list) {
            if (!(elem.distance(point) < deleteSensitivity)) continue;
            list.remove(elem);
            return true;
        }
        return false;
    }

    public void setSensitivity(double createSensitivity, double deleteSensitivity) {
        this.createSensitivity = createSensitivity;
        this.deleteSensitivity = deleteSensitivity;
    }
}

