/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.buckminster.cmdline.CommandInfo;
import org.eclipse.buckminster.cmdline.Headless;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.cmdline.parser.ParseResult;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractCommand {
    private static final OptionDescriptor helpDescriptor = new OptionDescriptor('?', "help", 1);
    private String calledUsingName;
    private CommandInfo cmdInfo;
    private boolean addHelpFlags;
    private boolean helpRequested = false;
    private Map<String, String> properties;

    public void addProperties(Map<String, String> props) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>(props);
        } else {
            this.properties.putAll(props);
        }
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public ProgressProvider getProgressProvider() {
        return new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return this.getDefaultMonitor();
            }
        };
    }

    public void init(boolean helpFlags) {
        this.addHelpFlags = helpFlags;
    }

    public int run(String cmdName) throws Exception {
        this.calledUsingName = cmdName;
        this.cmdInfo = CommandInfo.getCommand(cmdName);
        return this.run(this.getProgressProvider().getDefaultMonitor());
    }

    protected void beginOptionProcessing() throws Exception {
    }

    protected void endOptionProcessing() throws Exception {
    }

    protected String getCalledUsingName() throws Exception {
        return this.calledUsingName;
    }

    protected CommandInfo getCommandInfo() throws Exception {
        return this.cmdInfo;
    }

    protected String getFullName() throws Exception {
        return this.cmdInfo.getFullName();
    }

    protected InputStream getHelpStream() throws Exception {
        Class<?> myClass = this.getClass();
        String helpResource = "/" + myClass.getName().replace('.', '/') + ".help";
        return myClass.getResourceAsStream(helpResource);
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(Headless.DEFINE_DESCRIPTOR);
        appendHere.add(Headless.PROPERTIES_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        String v;
        if (option.is(Headless.DEFINE_DESCRIPTOR)) {
            v = option.getValue();
            Matcher m = Headless.DEFINE_PATTERN.matcher(v);
            if (!m.matches()) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.Not_a_key_value_string_0, (Object)v));
            }
            String key = m.group(1);
            String value = m.group(2) == null ? "" : m.group(2);
            this.addProperty(key, value);
        }
        if (option.is(Headless.PROPERTIES_DESCRIPTOR)) {
            v = option.getValue();
            BufferedInputStream input = null;
            try {
                try {
                    URL propsURL = URLUtils.normalizeToURL((String)v);
                    input = new BufferedInputStream(propsURL.openStream());
                    Properties props = new Properties();
                    props.load(input);
                    Enumeration<?> names = props.propertyNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        this.addProperty(name, props.getProperty(name));
                    }
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.Invalid_URL_or_Path_0, (Object)v));
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
    }

    protected void help() throws Exception {
        this.help(this.getHelpStream());
    }

    protected void help(InputStream helpStream) throws Exception {
        if (helpStream == null) {
            System.err.println(NLS.bind((String)Messages.AbstractCommand_Help_missing_for_0, (Object)this.getFullName()));
        } else {
            try {
                System.out.print(NLS.bind((String)Messages.AbstractCommand_Help_text_for_0, (Object)this.getFullName()));
                IOUtils.copy((InputStream)helpStream, (OutputStream)System.out, null);
            }
            finally {
                IOUtils.close((Closeable)helpStream);
            }
            System.out.flush();
        }
    }

    protected boolean isHelpRequested() {
        return this.helpRequested;
    }

    protected abstract int run(IProgressMonitor var1) throws Exception;

    final int basicRun(String calledAs, CommandInfo commandInfo, String[] commandArgs) throws Exception {
        int n;
        block12: {
            this.calledUsingName = calledAs;
            this.cmdInfo = commandInfo;
            ArrayList<OptionDescriptor> optionDescriptors = new ArrayList<OptionDescriptor>();
            this.getOptionDescriptors(optionDescriptors);
            if (this.addHelpFlags) {
                optionDescriptors.add(helpDescriptor);
            }
            Properties sysProps = null;
            try {
                this.parseOptions(commandArgs, optionDescriptors);
                if (this.isHelpRequested()) {
                    this.help();
                    return 0;
                }
                if (this.properties != null && !this.properties.isEmpty()) {
                    sysProps = System.getProperties();
                    Properties cmdProps = new Properties(sysProps);
                    for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                        cmdProps.setProperty(entry.getKey(), entry.getValue());
                    }
                    System.setProperties(cmdProps);
                }
                n = this.run(this.getProgressProvider().getDefaultMonitor());
                if (sysProps == null) break block12;
            }
            catch (UsageException e) {
                System.err.println(e.getMessage());
                if (e.isEmitHelp()) {
                    this.help();
                }
                return 1;
            }
            finally {
                if (sysProps != null) {
                    System.setProperties(sysProps);
                }
            }
            System.setProperties(sysProps);
        }
        return n;
    }

    private void parseOptions(String[] args, List<OptionDescriptor> optionDescriptors) throws Exception {
        ParseResult pr = ParseResult.parse(args, optionDescriptors);
        Option[] options = pr.getOptions();
        this.helpRequested = false;
        this.beginOptionProcessing();
        int top = options.length;
        int idx = 0;
        while (idx < top) {
            Option option = options[idx];
            if (option.is(helpDescriptor)) {
                this.helpRequested = true;
            } else {
                this.handleOption(option);
            }
            ++idx;
        }
        this.endOptionProcessing();
        if (!this.helpRequested) {
            this.handleUnparsed(pr.getUnparsed());
        }
    }
}

