/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.IllegalCommandAliasException;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class CommandInfo {
    public static final int NORMAL = 0;
    public static final int DEPRECATED = 1;
    public static final int HIDDEN = 2;
    public static final int DISABLED = 3;
    private static final String COMMAND_EXTPOINT = "org.eclipse.buckminster.cmdline.commands";
    private static final String ALIAS_ELEMENTS = "alias";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DEPRECATED_BY_ATTRIBUTE = "deprecatedBy";
    private static final char PERIOD_CHARACTER = '.';
    private static final String STATUS_ATTRIBUTE = "status";
    private static final String ADD_HELP_FLAGS_ATTRIBUTE = "addhelpflags";
    private static CommandInfo[] commandInfos;
    private final String[] aliases;
    private final IConfigurationElement cfgElement;
    private final String deprecatedBy;
    private final String name;
    private final String[] allNames;
    private final String namespace;
    private final int status;

    public static CommandInfo getCommand(String commandName) throws UsageException {
        CommandInfo ci;
        ArrayList<CommandInfo> matches = new ArrayList<CommandInfo>();
        CommandInfo[] implementors = CommandInfo.getImplementors();
        int top = implementors.length;
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        while (idx < top) {
            ci = implementors[idx];
            if (ci.getStatus() != 3) {
                String[] allNames = ci.getAllNames();
                int nidx = 0;
                while (nidx < allNames.length) {
                    String[] parts = allNames[nidx].split("\\.");
                    int len = parts.length;
                    int i = 0;
                    while (i < len) {
                        sb.setLength(0);
                        int j = len - i - 1;
                        while (j < len) {
                            if (sb.length() != 0) {
                                sb.append('.');
                            }
                            sb.append(parts[j]);
                            ++j;
                        }
                        if (sb.toString().equals(commandName)) {
                            matches.add(ci);
                        }
                        ++i;
                    }
                    ++nidx;
                }
            }
            ++idx;
        }
        int foundMatches = matches.size();
        if (foundMatches == 0) {
            throw new UsageException(NLS.bind((String)Messages.CommandInfo_Command_0_not_found, (Object)commandName));
        }
        if (foundMatches > 1) {
            sb.setLength(0);
            sb.append(NLS.bind((String)Messages.CommandInfo_Multiple_matches_for_0_for, (Object)commandName));
            int idx2 = 0;
            while (idx2 < foundMatches) {
                CommandInfo ci2 = (CommandInfo)matches.get(idx2);
                sb.append(ci2.getFullName());
                sb.append(NLS.bind((String)Messages.CommandInfo_implemented_by_class_0, (Object)ci2.getImplementingClass()));
                if (idx2 < foundMatches - 1) {
                    sb.append(", ");
                }
                ++idx2;
            }
            throw new UsageException(sb.toString());
        }
        ci = (CommandInfo)matches.get(0);
        if (ci.getStatus() == 1) {
            sb.setLength(0);
            sb.append(NLS.bind((String)Messages.CommandInfo_Command_0_is_deprecated, (Object)ci.getName()));
            String by = ci.getDeprecatedBy();
            if (by != null) {
                sb.append(NLS.bind((String)Messages.CommandInfo_Use_command_0_instead, (Object)by));
            }
            Buckminster.getLogger().warning(sb.toString(), new Object[0]);
        }
        return ci;
    }

    public static synchronized CommandInfo[] getImplementors() {
        if (commandInfos == null) {
            IExtensionRegistry er = Platform.getExtensionRegistry();
            IConfigurationElement[] elems = er.getConfigurationElementsFor(COMMAND_EXTPOINT);
            commandInfos = new CommandInfo[elems.length];
            int i = 0;
            while (i < elems.length) {
                CommandInfo.commandInfos[i] = new CommandInfo(elems[i]);
                ++i;
            }
        }
        return commandInfos;
    }

    private static int parseCommandStatus(String statusString) {
        int status;
        if ("normal".equalsIgnoreCase(statusString)) {
            status = 0;
        } else if ("deprecated".equalsIgnoreCase(statusString)) {
            status = 1;
        } else if ("hidden".equalsIgnoreCase(statusString)) {
            status = 2;
        } else if ("disabled".equalsIgnoreCase(statusString)) {
            status = 3;
        } else {
            throw new IllegalArgumentException(NLS.bind((String)Messages.CommandInfo__0_is_not_a_valid_command_status, (Object)statusString));
        }
        return status;
    }

    private CommandInfo(IConfigurationElement cfgElement) {
        this.cfgElement = cfgElement;
        this.status = CommandInfo.parseCommandStatus(cfgElement.getAttribute(STATUS_ATTRIBUTE));
        IExtension ext = cfgElement.getDeclaringExtension();
        StringBuffer ns = new StringBuffer(ext.getNamespaceIdentifier());
        String n = cfgElement.getAttribute(NAME_ATTRIBUTE);
        int period = n.lastIndexOf(46);
        if (period != -1) {
            ns.append('.').append(n.substring(0, period));
            n = n.substring(period + 1);
        }
        this.namespace = ns.toString();
        this.name = n;
        IConfigurationElement[] aliasElements = cfgElement.getChildren(ALIAS_ELEMENTS);
        HashSet<String> uniqueNames = new HashSet<String>();
        int i = 0;
        while (i < aliasElements.length) {
            String alias = aliasElements[i].getAttribute(NAME_ATTRIBUTE);
            if (alias.indexOf(46) != -1) {
                throw new IllegalCommandAliasException(alias);
            }
            if (!n.equals(alias)) {
                uniqueNames.add(alias);
            }
            ++i;
        }
        this.aliases = uniqueNames.toArray(new String[uniqueNames.size()]);
        uniqueNames.clear();
        uniqueNames.add(String.valueOf(this.namespace) + '.' + n);
        i = 0;
        while (i < this.aliases.length) {
            uniqueNames.add(String.valueOf(this.namespace) + '.' + this.aliases[i]);
            ++i;
        }
        this.allNames = uniqueNames.toArray(new String[uniqueNames.size()]);
        this.deprecatedBy = cfgElement.getAttribute(DEPRECATED_BY_ATTRIBUTE);
    }

    public AbstractCommand createInstance() throws CoreException {
        AbstractCommand cmd = (AbstractCommand)this.cfgElement.createExecutableExtension(CLASS_ATTRIBUTE);
        cmd.init(Boolean.valueOf(this.cfgElement.getAttribute(ADD_HELP_FLAGS_ATTRIBUTE)));
        return cmd;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getAllNames() {
        return this.allNames;
    }

    public IConfigurationElement getCfgElement() {
        return this.cfgElement;
    }

    public String getDeprecatedBy() {
        return this.deprecatedBy;
    }

    public String getFullName() {
        return this.allNames[0];
    }

    public String getImplementingClass() {
        return this.cfgElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getStatus() {
        return this.status;
    }
}

