/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.JobBlocker;
import org.eclipse.buckminster.core.materializer.WorkspaceBindingInstallJob;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public abstract class WorkspaceCommand
extends AbstractCommand {
    private boolean inWorkspace = false;

    private static void saveWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(null, 300);
        try {
            IStatus saveStatus = ((Workspace)ResourcesPlugin.getWorkspace()).save(true, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            if (saveStatus != null && !saveStatus.isOK()) {
                throw new ResourceException(saveStatus);
            }
        }
        catch (Throwable e) {
            Buckminster.getLogger().error(e, NLS.bind((String)Messages.Error_while_saving_workspace_0, (Object)e.getMessage()), new Object[0]);
        }
        monitor.done();
    }

    protected void initWorkspace(IProgressMonitor monitor) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDesc = ws.getDescription();
        wsDesc.setAutoBuilding(false);
        wsDesc.setSnapshotInterval(Long.MAX_VALUE);
        ws.setDescription(wsDesc);
        WorkspaceCommand.saveWorkspace(monitor);
    }

    protected abstract int internalRun(IProgressMonitor var1) throws Exception;

    public boolean isInWorkspace() {
        return this.inWorkspace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int run(IProgressMonitor monitor) throws Exception {
        int n;
        int n2;
        Job[] jobArray;
        IJobManager jobManager;
        Logger logger;
        Throwable throwable2;
        JobBlocker jobBlocker;
        block15: {
            int n3;
            monitor.beginTask(null, 1000);
            jobBlocker = new JobBlocker();
            jobBlocker.addClassBlock("org.eclipse.core.internal.events.AutoBuildJob");
            jobBlocker.addClassBlock("org.eclipse.jdt.internal.core.search.processing.JobManager$1$ProgressJob");
            try {
                if (!this.isInWorkspace()) {
                    this.initWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                jobBlocker.addClassBlock(DelayedSnapshotJob.class);
                n3 = this.internalRun(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                if (this.isInWorkspace()) {
                    jobBlocker.release();
                    return n3;
                }
            }
            catch (Throwable throwable2) {
                if (this.isInWorkspace()) {
                    jobBlocker.release();
                    throw throwable2;
                }
                logger = CorePlugin.getLogger();
                logger.debug("Doing full workspace refresh", new Object[0]);
                try {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                catch (Throwable e) {
                    Buckminster.getLogger().error(NLS.bind((String)Messages.Error_while_refreshing_workspace_0, (Object)e.getMessage()), new Object[]{e});
                }
                jobManager = Job.getJobManager();
                logger.debug("Cancel jobs that are known to run indefinitely...", new Object[0]);
                WorkspaceBindingInstallJob.stop();
                jobArray = jobManager.find(null);
                n2 = jobArray.length;
                n = 0;
                break block15;
            }
            Logger logger2 = CorePlugin.getLogger();
            logger2.debug("Doing full workspace refresh", new Object[0]);
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            }
            catch (Throwable e) {
                Buckminster.getLogger().error(NLS.bind((String)Messages.Error_while_refreshing_workspace_0, (Object)e.getMessage()), new Object[]{e});
            }
            IJobManager jobManager2 = Job.getJobManager();
            logger2.debug("Cancel jobs that are known to run indefinitely...", new Object[0]);
            WorkspaceBindingInstallJob.stop();
            Job[] jobArray2 = jobManager2.find(null);
            int n4 = jobArray2.length;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    Thread joinWait = new Thread(jobManager2, logger2){
                        private final /* synthetic */ IJobManager val$jobManager;
                        private final /* synthetic */ Logger val$logger;
                        {
                            this.val$jobManager = iJobManager;
                            this.val$logger = logger;
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public void run() {
                            block6: {
                                try {
                                    var4_1 = this.val$jobManager.find(null);
                                    var3_3 = var4_1.length;
                                    var2_5 = 0;
                                    while (var2_5 < var3_3) {
                                        job = var4_1[var2_5];
                                        if (job.getState() == 4 && !job.toString().startsWith("ThreadJob")) {
                                            this.val$logger.debug("  Joining JOB: (%s) %s", new Object[]{job.getClass().getName(), job.toString()});
                                            job.join();
                                        }
                                        ++var2_5;
                                    }
                                    break block6;
                                }
                                catch (InterruptedException e) {
                                    var5_9 = this.val$jobManager.find(null);
                                    var4_2 = var5_9.length;
                                    var3_4 = 0;
                                    ** while (var3_4 < var4_2)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    job = var5_9[var3_4];
                                    state = job.getState();
                                    if (state != 0) {
                                        this.val$logger.debug("  JOB: %s is still active", new Object[]{job.toString()});
                                        job.cancel();
                                    }
                                    ++var3_4;
                                    continue;
                                }
                            }
                        }
                    };
                    logger2.debug("Waiting for jobs to end", new Object[0]);
                    joinWait.start();
                    joinWait.join(60000L);
                    joinWait.interrupt();
                    jobBlocker.removeClassBlock(DelayedSnapshotJob.class);
                    WorkspaceCommand.saveWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                    monitor.done();
                    return n3;
                }
                Job job = jobArray2[n5];
                if (job instanceof StringPoolJob || job instanceof DelayedSnapshotJob) {
                    job.cancel();
                    logger2.debug("CANCELED JOB: (%s) %s", new Object[]{job.getClass().getName(), job.toString()});
                }
                ++n5;
            }
        }
        while (true) {
            if (n >= n2) {
                Thread joinWait = new /* invalid duplicate definition of identical inner class */;
                logger.debug("Waiting for jobs to end", new Object[0]);
                joinWait.start();
                joinWait.join(60000L);
                joinWait.interrupt();
                jobBlocker.removeClassBlock(DelayedSnapshotJob.class);
                WorkspaceCommand.saveWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                monitor.done();
                throw throwable2;
            }
            Job job = jobArray[n];
            if (job instanceof StringPoolJob || job instanceof DelayedSnapshotJob) {
                job.cancel();
                logger.debug("CANCELED JOB: (%s) %s", new Object[]{job.getClass().getName(), job.toString()});
            }
            ++n;
        }
    }

    public void setInWorkspace(boolean inWorkspace) {
        this.inWorkspace = inWorkspace;
    }
}

