/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.IProperties;
import org.eclipse.buckminster.core.helpers.MapUnion;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SAXEmitter {
    public static void emitProperties(ContentHandler handler, Map<String, String> props, String namespace, String prefix, boolean raw, boolean includeDefaults) throws SAXException {
        if (raw && props instanceof ExpandingProperties) {
            ((ExpandingProperties)props).emitProperties(handler, namespace, prefix, includeDefaults);
            return;
        }
        TreeSet<String> sorted = new TreeSet<String>();
        if (includeDefaults) {
            for (String name : props.keySet()) {
                String sysValue = System.getProperty(name);
                if (sysValue != null && sysValue.equals(props.get(name))) continue;
                sorted.add(name);
            }
        } else {
            Set<Object> keySet = props instanceof IProperties ? ((IProperties)props).overlayKeySet() : (props instanceof MapUnion ? ((MapUnion)props).overlayKeySet() : props.keySet());
            for (String name : keySet) {
                sorted.add(name);
            }
        }
        String plName = "property";
        String pqName = Utils.makeQualifiedName((String)prefix, (String)plName);
        AttributesImpl attrs = new AttributesImpl();
        boolean withMutableAttr = props instanceof IProperties && ((IProperties)props).supportsMutability();
        for (String name : sorted) {
            String value = props.get(name);
            if (value == null || value.length() == 0) continue;
            attrs.clear();
            Utils.addAttribute((AttributesImpl)attrs, (String)"key", (String)name);
            Utils.addAttribute((AttributesImpl)attrs, (String)"value", (String)value);
            if (withMutableAttr && ((IProperties)props).isMutable(name)) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"mutable", (String)"true");
            }
            handler.startElement(namespace, plName, pqName, attrs);
            handler.endElement(namespace, plName, pqName);
        }
    }
}

