/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.parser;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.Replace;
import org.eclipse.buckminster.core.common.parser.ValueFilterHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReplaceHandler
extends ValueFilterHandler {
    static final String TAG = "replace";
    private final MatchHandler matchHandler = new MatchHandler((AbstractHandler)this);

    public ReplaceHandler(AbstractHandler parent) {
        super(parent);
    }

    @Override
    public void childPopped(ChildHandler child) {
        if (child == this.matchHandler) {
            ((Replace)this.getValueHolder()).addMatch(this.matchHandler.getMatch());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        MatchHandler ch = "match".equals(localName) ? this.matchHandler : super.createHandler(uri, localName, attrs);
        return ch;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        Replace rp = new Replace();
        String pattern = ReplaceHandler.getOptionalStringValue((Attributes)attrs, (String)"pattern");
        String replacement = ReplaceHandler.getOptionalStringValue((Attributes)attrs, (String)"replacement");
        if (pattern != null) {
            if (replacement == null) {
                throw new SAXParseException(Messages.Pattern_but_no_replacement, this.getDocumentLocator());
            }
            boolean quotePattern = ReplaceHandler.getOptionalBooleanValue((Attributes)attrs, (String)"quotePattern", (boolean)false);
            rp.addMatch(new Replace.Match(pattern, replacement, quotePattern));
        } else if (replacement != null) {
            throw new SAXParseException(Messages.Replacement_but_no_pattern, this.getDocumentLocator());
        }
        this.setValueHolder(rp);
    }

    public static class MatchHandler
    extends ExtensionAwareHandler {
        static final String TAG = "match";
        private Replace.Match match;

        public MatchHandler(AbstractHandler parent) {
            super(parent);
        }

        public void handleAttributes(Attributes attrs) throws SAXException {
            String pattern = this.getStringValue(attrs, "pattern");
            String replacement = this.getStringValue(attrs, "replacement");
            boolean quotePattern = MatchHandler.getOptionalBooleanValue((Attributes)attrs, (String)"quotePattern", (boolean)false);
            this.match = new Replace.Match(pattern, replacement, quotePattern);
        }

        final Replace.Match getMatch() {
            return this.match;
        }
    }
}

