/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class QualifiedDependency {
    private final ComponentRequest request;
    private final Set<String> attributes;

    public QualifiedDependency(ComponentRequest request, Collection<String> attributes) {
        this.request = request;
        this.attributes = Utils.createUnmodifiableSet(attributes);
    }

    public QualifiedDependency applyAdvice(IAdvisorNode advice) {
        Collection<String> attrs;
        if (advice == null) {
            return this;
        }
        boolean change = false;
        ComponentRequest rq = this.request;
        VersionRange dsg = advice.getVersionOverride();
        if (dsg != null) {
            change = true;
            rq = new ComponentRequest(rq.getName(), rq.getComponentTypeID(), dsg, rq.getFilter());
        }
        if ((attrs = advice.getAttributes()).size() > 0) {
            change = true;
            if (advice.isPrune() && this.attributes.size() > 0 && !this.attributes.containsAll(attrs)) {
                HashSet<String> pruned = new HashSet<String>();
                for (String attrName : attrs) {
                    if (!this.attributes.contains(attrName)) continue;
                    pruned.add(attrName);
                }
                if (pruned.size() == 0) {
                    return null;
                }
                attrs = pruned;
            }
        } else {
            attrs = this.attributes;
        }
        return change ? new QualifiedDependency(rq, attrs) : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QualifiedDependency)) {
            return false;
        }
        QualifiedDependency that = (QualifiedDependency)o;
        return this.request.equals(that.request) && this.attributes.equals(that.attributes);
    }

    public final Set<String> getAttributeNames() {
        return this.attributes;
    }

    public final ComponentRequest getRequest() {
        return this.request;
    }

    public boolean hasAllAttributes(Collection<String> attrs) {
        return this.attributes.containsAll(attrs);
    }

    public boolean hasAllAttributes(String[] attrs) {
        return this.hasAllAttributes(Arrays.asList(attrs));
    }

    public int hashCode() {
        return this.request.hashCode() * 31 + this.attributes.hashCode();
    }

    public QualifiedDependency mergeDependency(QualifiedDependency newQDep) throws CoreException {
        Set<String> allAttrs;
        Set<String> attrs = newQDep.getAttributeNames();
        ComponentRequest newRequest = this.request.mergeDesignator(newQDep.getRequest());
        if (newRequest == this.request && this.hasAllAttributes(attrs)) {
            return this;
        }
        if (this.attributes.size() == 0) {
            allAttrs = attrs;
        } else if (attrs.size() == 0) {
            allAttrs = this.attributes;
        } else {
            allAttrs = new HashSet<String>(this.attributes);
            allAttrs.addAll(attrs);
        }
        return new QualifiedDependency(newRequest, allAttrs);
    }

    public String toString() {
        if (this.attributes.isEmpty()) {
            return this.request.toString();
        }
        StringBuilder bld = new StringBuilder(this.request.toString());
        bld.append('[');
        Iterator<String> attrs = this.attributes.iterator();
        bld.append(attrs.next());
        while (attrs.hasNext()) {
            bld.append(',');
            bld.append(attrs.next());
        }
        bld.append(']');
        return bld.toString();
    }
}

