/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecElementBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class PrerequisiteBuilder
extends CSpecElementBuilder
implements IPrerequisite {
    private String alias;
    private final AttributeBuilder attributeBuilder;
    private String component;
    private String componentType;
    private VersionRange versionRange;
    private boolean contributor = true;
    private Pattern excludePattern;
    private Pattern includePattern;
    private Filter filter;

    PrerequisiteBuilder(AttributeBuilder attributeBuilder) {
        super(attributeBuilder.getCSpecBuilder());
        this.attributeBuilder = attributeBuilder;
    }

    @Override
    public void clear() {
        super.clear();
        this.alias = null;
        this.component = null;
        this.componentType = null;
        this.versionRange = null;
        this.contributor = true;
        this.excludePattern = null;
        this.includePattern = null;
        this.filter = null;
    }

    public Prerequisite createPrerequisite() {
        return new Prerequisite(this);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getAttribute() {
        return this.getAttributeBuilder().getName();
    }

    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public String getComponentName() {
        return this.component;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public Pattern getExcludePattern() {
        return this.excludePattern;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public void initFrom(IPrerequisite prerequisite) {
        super.initFrom(prerequisite.getName());
        this.alias = prerequisite.getAlias();
        this.component = prerequisite.getComponentName();
        this.componentType = prerequisite.getComponentType();
        this.versionRange = prerequisite.getVersionRange();
        this.contributor = prerequisite.isContributor();
        this.excludePattern = prerequisite.getExcludePattern();
        this.includePattern = prerequisite.getIncludePattern();
        this.filter = prerequisite.getFilter();
    }

    @Override
    public boolean isContributor() {
        return this.contributor;
    }

    @Override
    public boolean isExternal() {
        return this.component != null;
    }

    @Override
    public boolean isMatch(String componentName, String attribute) {
        return Prerequisite.isMatch(componentName, attribute, this.excludePattern, this.includePattern);
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setComponentName(String component) {
        this.component = component;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setContributor(boolean contributor) {
        this.contributor = contributor;
    }

    public void setExcludePattern(Pattern excludePattern) {
        this.excludePattern = excludePattern;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setIncludePattern(Pattern includePattern) {
        this.includePattern = includePattern;
    }

    public void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
    }

    public String toString() {
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        if (this.component == null) {
            return name;
        }
        StringBuilder bld = new StringBuilder();
        bld.append(this.component);
        if (this.componentType != null) {
            bld.append(':');
            bld.append(this.componentType);
        }
        bld.append('#');
        bld.append(name);
        if (this.versionRange != null) {
            bld.append('/');
            bld.append(VersionHelper.getHumanReadable(this.versionRange));
        }
        return bld.toString();
    }

    void finalWrapUp(List<ComponentRequestBuilder> dependencies) {
        if (this.componentType != null || this.versionRange != null) {
            int hitsTotal = 0;
            int hitsOnType = 0;
            int hitsOnRange = 0;
            int idx = dependencies.size();
            while (--idx >= 0) {
                ComponentRequestBuilder dep = dependencies.get(idx);
                if (!this.component.equals(dep.getName())) continue;
                ++hitsTotal;
                if (this.componentType != null) {
                    if (!this.componentType.equals(dep.getComponentTypeID())) continue;
                    ++hitsOnType;
                    if (this.versionRange == null || dep.getVersionRange() == null || dep.getVersionRange().intersect(this.versionRange) == null) continue;
                    ++hitsOnRange;
                    continue;
                }
                if (this.versionRange == null || dep.getVersionRange() == null || dep.getVersionRange().intersect(this.versionRange) == null) continue;
                ++hitsOnRange;
            }
            if (hitsOnType == hitsTotal) {
                this.componentType = null;
            }
            if (hitsOnRange == hitsTotal) {
                this.versionRange = null;
            }
        }
    }
}

