/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequestConflictException;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.helpers.AttributesImpl;

public class ComponentRequest
extends ComponentName
implements IComponentRequest {
    public static final String TAG = "component";
    public static final String ATTR_VERSION_DESIGNATOR = "versionDesignator";
    public static final String ATTR_VERSION_TYPE = "versionType";
    public static final String ATTR_FILTER = "filter";
    private final VersionRange versionRange;
    private final Filter filter;
    public static final Filter P2_OPTIONAL_FILTER;
    public static final Filter SOURCE_BUNDLE_FILTER;
    public static final String FILTER_ECLIPSE_P2_OPTIONAL = "(!(eclipse.p2.optional=false))";
    public static final String FILTER_SOURCE_BUNDLE = "(buckminster.download.source=true)";
    public static final String FILTER_OPTIONAL_SOURCE_BUNDLE = "(&(!(eclipse.p2.optional=false))(buckminster.download.source=true))";

    static {
        try {
            P2_OPTIONAL_FILTER = FilterFactory.newInstance((String)FILTER_ECLIPSE_P2_OPTIONAL);
            SOURCE_BUNDLE_FILTER = FilterFactory.newInstance((String)FILTER_SOURCE_BUNDLE);
        }
        catch (InvalidSyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public ComponentRequest(ComponentRequestBuilder bld) {
        super(bld.getName(), bld.getComponentTypeID());
        VersionRange vr = bld.getVersionRange();
        if (vr != null && vr.equals((Object)VersionRange.emptyRange)) {
            vr = null;
        }
        this.versionRange = vr;
        this.filter = bld.getFilter();
    }

    public ComponentRequest(String name, String componentType, String versionRangeStr, String versionTypeId) throws CoreException {
        this(name, componentType, versionRangeStr, versionTypeId, null);
    }

    public ComponentRequest(String name, String componentType, String versionRangeStr, String versionTypeId, Filter filter) throws CoreException {
        this(name, componentType, VersionHelper.createRange(versionTypeId, versionRangeStr), filter);
    }

    public ComponentRequest(String name, String componentType, VersionRange versionRange) {
        this(name, componentType, versionRange, null);
    }

    public ComponentRequest(String name, String componentType, VersionRange versionRange, Filter filter) {
        super(name, componentType);
        if (versionRange != null && versionRange.equals((Object)VersionRange.emptyRange)) {
            versionRange = null;
        }
        this.versionRange = versionRange;
        this.filter = filter;
    }

    public void appendViewName(StringBuilder bld) {
        bld.append(this.getName());
        String componentType = this.getComponentTypeID();
        if (componentType != null) {
            bld.append(':');
            bld.append(componentType);
        }
        if (this.filter != null) {
            bld.append(this.filter);
        }
    }

    @Override
    public boolean designates(IComponentIdentifier id) {
        return !(!Trivial.equalsAllowNull((Object)this.getName(), (Object)id.getName()) || this.getComponentTypeID() != null && !this.getComponentTypeID().equals(id.getComponentTypeID()) || this.versionRange != null && !this.versionRange.isIncluded(id.getVersion()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return super.equals(o) && Trivial.equalsAllowNull((Object)this.versionRange, (Object)((ComponentRequest)o).versionRange) && Trivial.equalsAllowNull((Object)this.filter, (Object)((ComponentRequest)o).filter);
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.versionRange != null) {
            p.put("buckminster.version.designator", this.versionRange.toString());
        }
        return p;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public String getViewName() {
        StringBuilder bld = new StringBuilder();
        this.appendViewName(bld);
        return bld.toString();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        return 31 * hash + (this.filter == null ? 0 : this.filter.hashCode());
    }

    public boolean isEnabled(Map<String, ? extends Object> properties) {
        return this.filter == null || this.filter.matchCase(properties);
    }

    public boolean isOptional() {
        return this.filter != null && this.filter.toString().contains(FILTER_ECLIPSE_P2_OPTIONAL);
    }

    public boolean isSynthetic() {
        return this.filter != null && this.filter.toString().contains(FILTER_ECLIPSE_P2_OPTIONAL);
    }

    public boolean isSyntheticSource() {
        return this.filter != null && this.filter.toString().contains(FILTER_SOURCE_BUNDLE);
    }

    public ComponentRequest mergeDesignator(ComponentRequest that) throws CoreException {
        if (!Trivial.equalsAllowNull((Object)this.getName(), (Object)that.getName())) {
            throw new ComponentRequestConflictException(this, that);
        }
        int cmp = 0;
        VersionRange thisVD = this.getVersionRange();
        VersionRange thatVD = that.getVersionRange();
        VersionRange mergedVD = null;
        if (thisVD == null) {
            if (thatVD != null) {
                cmp = 1;
                mergedVD = thatVD;
            }
        } else if (thatVD == null) {
            cmp = -1;
            mergedVD = thisVD;
        } else {
            mergedVD = thisVD.intersect(thatVD);
            if (mergedVD == null) {
                throw new ComponentRequestConflictException(this, that);
            }
            if (mergedVD.equals((Object)thisVD)) {
                if (!mergedVD.equals((Object)thatVD)) {
                    cmp = -1;
                }
            } else {
                cmp = mergedVD.equals((Object)thatVD) ? 1 : 2;
            }
        }
        String thisCType = this.getComponentTypeID();
        String thatCType = that.getComponentTypeID();
        String mergedCType = null;
        if (thisCType == null) {
            if (thatCType != null) {
                if (cmp == 0) {
                    cmp = 1;
                }
                mergedCType = thatCType;
            }
        } else {
            if (thatCType != null) {
                if (!thisCType.equals(thatCType)) {
                    throw new ComponentRequestConflictException(this, that);
                }
            } else if (cmp == 0) {
                cmp = -1;
            }
            mergedCType = thisCType;
        }
        Filter thisFilter = this.getFilter();
        Filter thatFilter = that.getFilter();
        boolean thisOptional = this.isOptional();
        boolean thatOptional = that.isOptional();
        Filter mergedFilter = null;
        if (!Trivial.equalsAllowNull((Object)thisFilter, (Object)thatFilter)) {
            if (thisOptional != thatOptional) {
                throw new ComponentRequestConflictException(this, that);
            }
            mergedFilter = thisFilter == null ? thatFilter : (thatFilter == null ? thisFilter : thisFilter.addFilterWithOr(thatFilter));
        } else {
            mergedFilter = thisFilter;
        }
        if (thisOptional) {
            if (!thatOptional) {
                if (cmp == -1 || cmp == 2) {
                    throw new ComponentRequestConflictException(this, that);
                }
                return that;
            }
        } else if (thatOptional) {
            if (cmp > 0) {
                throw new ComponentRequestConflictException(this, that);
            }
            return this;
        }
        if (Trivial.equalsAllowNull((Object)mergedVD, (Object)thisVD) && Trivial.equalsAllowNull((Object)mergedCType, (Object)thisCType) && Trivial.equalsAllowNull((Object)thisFilter, (Object)mergedFilter)) {
            return this;
        }
        if (Trivial.equalsAllowNull((Object)mergedVD, (Object)thatVD) && Trivial.equalsAllowNull((Object)mergedCType, (Object)thatCType) && Trivial.equalsAllowNull((Object)thatFilter, (Object)mergedFilter)) {
            return that;
        }
        return new ComponentRequest(this.getName(), mergedCType, mergedVD, mergedFilter);
    }

    @Override
    public ComponentName toPureComponentName() {
        return new ComponentName(this);
    }

    @Override
    public void toString(StringBuilder bld) {
        super.toString(bld);
        if (this.versionRange != null) {
            bld.append('/');
            bld.append(VersionHelper.getHumanReadable(this.versionRange));
        }
        if (this.filter != null) {
            bld.append(this.filter);
        }
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.versionRange != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_DESIGNATOR, (String)this.versionRange.toString());
        }
        if (this.filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.filter.toString());
        }
    }
}

