/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.cspec.parser.ActionHandler;
import org.eclipse.buckminster.core.cspec.parser.ArtifactHandler;
import org.eclipse.buckminster.core.cspec.parser.CSpecElementHandler;
import org.eclipse.buckminster.core.cspec.parser.IAttributeBuilderSupport;
import org.eclipse.buckminster.core.cspec.parser.ICSpecBuilderSupport;
import org.eclipse.buckminster.core.cspec.parser.PathHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProductsHandler
extends ExtensionAwareHandler
implements ChildPoppedListener,
ICSpecBuilderSupport,
IAttributeBuilderSupport {
    public static final String TAG = "products";
    private final PathHandler pathHandler = new PathHandler((AbstractHandler)this);
    private final ProductArtifactHandler privateHandler = new ProductArtifactHandler((AbstractHandler)this, false);
    private final ProductArtifactHandler publicHandler = new ProductArtifactHandler((AbstractHandler)this, true);

    ProductsHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.pathHandler) {
            ((ActionBuilder)this.getAttributeBuilder()).addProductPath(this.pathHandler.getPath());
        } else if (child == this.publicHandler) {
            this.addProductArtifact(this.publicHandler.getAttributeBuilder());
        } else if (child == this.privateHandler) {
            this.addProductArtifact(this.privateHandler.getAttributeBuilder());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch = null;
        ch = "path".equals(localName) ? this.pathHandler : ("public".equals(localName) ? this.publicHandler : ("private".equals(localName) ? this.privateHandler : super.createHandler(uri, localName, attrs)));
        return ch;
    }

    @Override
    public TopLevelAttributeBuilder getAttributeBuilder() {
        return ((IAttributeBuilderSupport)this.getParentHandler()).getAttributeBuilder();
    }

    @Override
    public CSpecBuilder getCSpecBuilder() {
        return ((ICSpecBuilderSupport)this.getParentHandler()).getCSpecBuilder();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        ActionHandler parent = (ActionHandler)this.getParentHandler();
        parent.setProductAlias(ProductsHandler.getOptionalStringValue((Attributes)attrs, (String)"alias"));
        parent.setProductFileCount(ProductsHandler.getOptionalIntValue((Attributes)attrs, (String)"fileCount", (int)-1));
        String tmp = ProductsHandler.getOptionalStringValue((Attributes)attrs, (String)"base");
        if (tmp != null) {
            parent.setProductBase(Path.fromPortableString((String)tmp));
        }
        if ((tmp = ProductsHandler.getOptionalStringValue((Attributes)attrs, (String)"upToDatePolicy")) != null) {
            try {
                parent.setUpToDatePolicy(UpToDatePolicy.valueOf(tmp));
            }
            catch (IllegalArgumentException e) {
                throw new SAXParseException(NLS.bind((String)Messages._0_is_not_a_valid_UpToDatePolicy, (Object)tmp), this.getDocumentLocator());
            }
        }
    }

    final void addProductArtifact(AttributeBuilder artifact) throws SAXException {
        try {
            this.getCSpecBuilder().addAttribute(artifact);
        }
        catch (AttributeAlreadyDefinedException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
    }

    final String getActionName() {
        return ((CSpecElementHandler)this.getParentHandler()).getBuilder().getName();
    }

    public static class ProductArtifactHandler
    extends ArtifactHandler {
        public ProductArtifactHandler(AbstractHandler parent, boolean publ) {
            super(parent, publ);
        }

        @Override
        public void handleAttributes(Attributes attrs) throws SAXException {
            super.handleAttributes(attrs);
            ActionArtifactBuilder productBuilder = (ActionArtifactBuilder)this.getBuilder();
            productBuilder.setActionName(((ProductsHandler)this.getParentHandler()).getActionName());
            productBuilder.setAlias(ProductArtifactHandler.getOptionalStringValue((Attributes)attrs, (String)"alias"));
        }

        @Override
        protected TopLevelAttributeBuilder createAttributeBuilder() {
            return this.getCSpecBuilder().createActionArtifactBuilder();
        }
    }
}

