/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspecext.builder.AlterAttributeBuilder;
import org.eclipse.buckminster.core.cspecext.model.AlterAction;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.core.runtime.IPath;

public class AlterActionBuilder
extends AlterAttributeBuilder {
    private final HashMap<String, Prerequisite> alteredPrerequisites = new HashMap();
    private final HashSet<String> removedPrerequisites = new HashSet();
    private final ExpandingProperties<String> alteredActorProperties = new ExpandingProperties();
    private final HashSet<String> removedActorProperties = new HashSet();
    private final ExpandingProperties<String> alteredProperties = new ExpandingProperties();
    private final HashSet<String> removedProperties = new HashSet();
    private final HashSet<IPath> removedPaths = new HashSet();

    public AlterActionBuilder(ActionBuilder baseBuilder) {
        super(baseBuilder);
    }

    public void addAlterActorProperty(String key, String value) {
        this.alteredActorProperties.put(key, value);
    }

    public void addAlterPrerequisite(Prerequisite value) throws PrerequisiteAlreadyDefinedException {
        String key = value.toString();
        if (this.alteredPrerequisites.containsKey(key)) {
            throw new PrerequisiteAlreadyDefinedException(this.getCSpecName(), this.getName(), key);
        }
        List<PrerequisiteBuilder> basePreqs = ((ActionBuilder)this.getBaseBuilder()).getPrerequisitesBuilder().getPrerequisites();
        if (GroupBuilder.indexOfPrerequisite(basePreqs, key) >= 0) {
            throw new PrerequisiteAlreadyDefinedException(this.getCSpecName(), this.getName(), key);
        }
        this.alteredPrerequisites.put(key, value);
    }

    public void addAlterProperty(String key, String value) {
        this.alteredProperties.put(key, value);
    }

    public void addRemoveActorProperty(String key) {
        this.removedActorProperties.add(key);
    }

    public void addRemovePrerequisite(String key) {
        this.removedPrerequisites.add(key);
    }

    public void addRemoveProductPath(IPath path) {
        this.removedPaths.add(path);
    }

    public void addRemoveProperty(String key) {
        this.removedProperties.add(key);
    }

    @Override
    public void clear() {
        super.clear();
        this.alteredPrerequisites.clear();
        this.removedPrerequisites.clear();
        this.alteredActorProperties.clear();
        this.removedActorProperties.clear();
        this.alteredProperties.clear();
        this.removedProperties.clear();
        this.removedPaths.clear();
    }

    @Override
    public AlterAttribute<?> createAlterAttribute() {
        return new AlterAction(this.createBase(), this.getRemovedHints(), this.getAlteredHints(), this.removedPrerequisites, this.alteredPrerequisites, this.removedActorProperties, this.alteredActorProperties, this.removedProperties, this.alteredProperties, this.removedPaths);
    }

    public ExpandingProperties<String> getAlterActorProperties() {
        return this.alteredActorProperties;
    }

    public ExpandingProperties<String> getAlterProperties() {
        return this.alteredProperties;
    }

    @Override
    Action createBase() {
        return ((ActionBuilder)this.getBaseBuilder()).createAttribute();
    }
}

