/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.model;

import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisitesBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.buckminster.core.cspecext.model.AlterGroup;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class AlterAction
extends AlterAttribute<Action> {
    public static final String ELEM_ALTER_PREREQUISITES = "alterPrerequisites";
    public static final String ELEM_ALTER_ACTOR_PROPERTIES = "alterActorProperties";
    public static final String ELEM_ALTER_PROPERTIES = "alterProperties";
    public static final String ELEM_ALTER_PRODUCTS = "alterProducts";
    public static final String ELEM_REMOVE_PRODUCT_PATH = "removeProductPath";
    public static final String ELEM_REMOVE_ATTRIBUTE = "removeAttribute";
    private final Map<String, String> alteredActorProperties;
    private final Set<String> removedActorProperties;
    private final Map<String, String> alteredProperties;
    private final Set<String> removedProperties;
    private final Set<IPath> removedPaths;
    private final Map<String, Prerequisite> alteredPrerequisites;
    private final Set<String> removedPrerequisites;

    public AlterAction(Action base, Set<String> removedHints, Map<String, String> alteredHints, Set<String> removedPrerequisites, Map<String, Prerequisite> alteredPrerequisites, Set<String> removedActorProperties, Map<String, String> alteredActorProperties, Set<String> removedProperties, Map<String, String> alteredProperties, Set<IPath> removedPaths) {
        super(base, removedHints, alteredHints);
        this.alteredPrerequisites = Utils.createUnmodifiableMap(alteredPrerequisites);
        this.removedPrerequisites = Utils.createUnmodifiableSet(removedPrerequisites);
        this.alteredActorProperties = ExpandingProperties.createUnmodifiableProperties(alteredActorProperties);
        this.removedActorProperties = Utils.createUnmodifiableSet(removedActorProperties);
        this.alteredProperties = ExpandingProperties.createUnmodifiableProperties(alteredProperties);
        this.removedProperties = Utils.createUnmodifiableSet(removedProperties);
        this.removedPaths = CSpec.createUnmodifiablePaths(removedPaths);
    }

    @Override
    public void alterAttribute(TopLevelAttributeBuilder attrBld) throws CoreException {
        if (!(attrBld instanceof ActionBuilder)) {
            throw BuckminsterException.fromMessage((String)"%s is not an action", (Object[])new Object[]{attrBld.getQualifiedName()});
        }
        ActionBuilder actionBld = (ActionBuilder)attrBld;
        IAction base = (IAction)this.getBase();
        PrerequisitesBuilder groupBld = actionBld.getPrerequisitesBuilder();
        AlterGroup ag = new AlterGroup(((Action)this.getBase()).getPrerequisiteGroup(), null, null, this.removedPrerequisites, this.alteredPrerequisites);
        ag.alterAttribute(groupBld);
        this.alterProductPaths(actionBld);
        this.alterActorProperties(actionBld);
        this.alterProperties(actionBld);
        this.alterDocumentation(actionBld);
        actionBld.setProductAlias(CSpecExtension.overrideCheckNull(actionBld.getProductAlias(), base.getProductAlias()));
        actionBld.setProductBase(CSpecExtension.overrideCheckNull(actionBld.getProductBase(), base.getProductBase()));
    }

    protected void alterActorProperties(ActionBuilder original) throws CoreException {
        AlterAction.performPropertyAlterations(original.getCSpecName(), original.getName(), "actorProperty", original.getActorProperties(), this.alteredActorProperties, ((Action)this.getBase()).getActorProperties(), this.removedActorProperties);
    }

    protected void alterProductPaths(ActionBuilder original) throws CoreException {
        AlterAction.alterPaths(original.getCSpecName(), original.getName(), original.getProductPaths(), ((Action)this.getBase()).getProductPaths(), this.removedPaths);
    }

    protected void alterProperties(ActionBuilder original) throws CoreException {
        AlterAction.performPropertyAlterations(original.getCSpecName(), original.getName(), "property", original.getProperties(), this.alteredProperties, ((Action)this.getBase()).getProperties(), this.removedProperties);
    }
}

