/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class FibonacciMonitorWrapper
extends ProgressMonitorWrapper {
    private int multiplier = 65536;
    private double totalWork = 0.0;
    private double worked = 0.0;
    private static final double goldenRatio = 1.6181818181818182;

    public FibonacciMonitorWrapper(IProgressMonitor monitor) {
        super(monitor);
    }

    public void beginTask(String name, int work) {
        this.totalWork *= (double)this.multiplier;
        this.totalWork = work;
        this.getWrappedProgressMonitor().beginTask(name, work);
    }

    public void internalWorked(double work) {
        double attempt = work * (double)this.multiplier;
        while (this.worked + attempt > this.totalWork / 1.6181818181818182 && this.multiplier > 1) {
            this.multiplier >>= 1;
            this.totalWork -= this.worked;
            this.worked = 0.0;
            attempt = work * (double)this.multiplier;
        }
        this.worked += attempt;
        if (this.worked >= this.totalWork) {
            attempt = 0.0;
            this.worked = this.totalWork;
        }
        this.getWrappedProgressMonitor().internalWorked(attempt);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }
}

