/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.StringTokenizer;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class FilterUtils {
    public static final String MATCH_ALL = "*";
    public static final MatchAll MATCH_ALL_OBJ = new MatchAll("*");

    public static org.eclipse.buckminster.osgi.filter.Filter createFilter(String os, String ws, String arch, String nl) {
        StringBuilder bld = new StringBuilder();
        int cnt = 0;
        if (FilterUtils.addProperty(bld, "target.os", os)) {
            ++cnt;
        }
        if (FilterUtils.addProperty(bld, "target.ws", ws)) {
            ++cnt;
        }
        if (FilterUtils.addProperty(bld, "target.arch", arch)) {
            ++cnt;
        }
        if (FilterUtils.addProperty(bld, "target.nl", nl)) {
            ++cnt;
        }
        if (cnt > 0) {
            if (cnt > 1) {
                StringBuilder and = new StringBuilder(bld.length() + 3);
                and.append("(&");
                and.append((CharSequence)bld);
                and.append(')');
                bld = and;
            }
            try {
                return FilterFactory.newInstance((String)bld.toString());
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static org.eclipse.buckminster.osgi.filter.Filter replaceAttributeNames(Filter filter, String from, String to) {
        if (filter == null) {
            return null;
        }
        try {
            return FilterFactory.newInstance((String)FilterUtils.replaceAttributeNames(filter.toString(), from, to));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String replaceAttributeNames(String filter, String from, String to) {
        if (filter == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder();
        boolean lastWasFilterStart = false;
        boolean lastWasEscape = false;
        StringTokenizer tokens = new StringTokenizer(filter, "\\&|!~<>=(). \t\r\f\n", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (lastWasFilterStart && token.equals(from)) {
                bld.append(to);
            } else {
                bld.append(token);
            }
            if (token.length() == 1) {
                if (lastWasEscape) {
                    lastWasEscape = false;
                    continue;
                }
                char c = token.charAt(0);
                if (Character.isWhitespace(c)) continue;
                if (c == '(') {
                    lastWasFilterStart = true;
                    continue;
                }
                lastWasEscape = c == '\\';
                continue;
            }
            lastWasEscape = false;
            lastWasFilterStart = false;
        }
        return bld.toString();
    }

    private static boolean addProperty(StringBuilder bld, String key, String value) {
        if ((value = TextUtils.notEmptyTrimmedString(value)) == null) {
            return false;
        }
        int bldStart = bld.length();
        int top = value.length();
        boolean startNew = true;
        boolean multi = false;
        int idx = 0;
        while (idx < top) {
            if (startNew) {
                if (idx > 0) {
                    bld.append(')');
                    multi = true;
                }
                bld.append('(');
                bld.append(key);
                bld.append('=');
                startNew = false;
            }
            char c = value.charAt(idx);
            switch (c) {
                case '(': 
                case ')': 
                case '\\': {
                    bld.append('\\');
                    bld.append(c);
                    break;
                }
                case ',': {
                    startNew = true;
                    break;
                }
                default: {
                    bld.append(c);
                }
            }
            ++idx;
        }
        bld.append(')');
        if (multi) {
            String expr = bld.substring(bldStart);
            bld.setLength(bldStart);
            bld.append("(|");
            bld.append(expr);
            bld.append(')');
        }
        return true;
    }

    public static class MatchAll {
        public MatchAll(String v) {
        }

        public boolean equals(Object o) {
            return true;
        }

        public int hashCode() {
            return FilterUtils.MATCH_ALL.hashCode();
        }

        public String toString() {
            return FilterUtils.MATCH_ALL;
        }
    }
}

