/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.core.runtime.CoreException;

public class ModelCache
implements IModelCache {
    private Map<String, ? extends Object> properties;
    private Map<String, PathGroup[]> pathGroupsCache;
    private Map<ComponentRequest, CSpec> cspecCache;

    public ModelCache() {
    }

    public ModelCache(Map<String, ? extends Object> properties) {
        this.properties = properties;
    }

    @Override
    public synchronized CSpec findCSpec(ICSpecData ownerCSpec, ComponentRequest request) throws CoreException {
        CSpec cspec = null;
        if (this.cspecCache == null) {
            this.cspecCache = new HashMap<ComponentRequest, CSpec>();
        } else {
            cspec = this.cspecCache.get(request);
        }
        if (cspec == null) {
            cspec = WorkspaceInfo.getResolution(request, false).getCSpec();
            this.cspecCache.put(request, cspec);
        }
        return cspec;
    }

    @Override
    public synchronized Collection<CSpec> getAllFoundCSpecs() {
        return this.cspecCache == null ? Collections.emptyList() : this.cspecCache.values();
    }

    @Override
    public synchronized Map<String, PathGroup[]> getPathGroupsCache() {
        if (this.pathGroupsCache == null) {
            this.pathGroupsCache = new HashMap<String, PathGroup[]>();
        }
        return this.pathGroupsCache;
    }

    @Override
    public synchronized Map<String, ? extends Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }
}

