/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.IDWrapper;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BillOfMaterials
extends BOMNode {
    public static final String ATTR_QUERY_ID = "componentQueryId";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_TOP_NODE_ID = "topNodeId";
    public static final int SEQUENCE_NUMBER = 3;
    public static final String TAG = "billOfMaterials";
    private transient HashMap<ComponentIdentifier, BOMNode> nodeMap;
    private final ComponentQuery query;
    private final Date timestamp;
    private final BOMNode topNode;

    public static BillOfMaterials create(BOMNode topNode, ComponentQuery query) throws CoreException {
        return BillOfMaterials.create(topNode, query, null);
    }

    public static BillOfMaterials create(BOMNode topNode, ComponentQuery query, Date timestamp) throws CoreException {
        BillOfMaterials bom;
        if (topNode == null) {
            throw new IllegalArgumentException(Messages.Top_node_cannot_be_null);
        }
        if (query == null) {
            throw new IllegalArgumentException(Messages.Component_query_cannot_be_null);
        }
        if (topNode instanceof BillOfMaterials && (bom = (BillOfMaterials)topNode).getQuery().equals(query)) {
            return bom;
        }
        return new BillOfMaterials(topNode, query, timestamp);
    }

    private static void addIfNotAdded(UUIDKeyed object, Set<UUID> unique, List<IDWrapper> wrappers) {
        UUID key = object.getId();
        if (unique.contains(key)) {
            return;
        }
        unique.add(key);
        wrappers.add(new IDWrapper(key, object));
    }

    private static void buildNodeMap(BOMNode node, HashMap<ComponentIdentifier, BOMNode> map) throws CoreException {
        Resolution resolution = node.getResolution();
        if (resolution == null) {
            return;
        }
        ComponentIdentifier id = resolution.getCSpec().getComponentIdentifier();
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, node);
        for (BOMNode child : node.getChildren()) {
            BillOfMaterials.buildNodeMap(child, map);
        }
    }

    private static void collectNodeContents(BOMNode node, Set<UUID> unique, List<IDWrapper> wrappers) throws CoreException {
        UUID nodeId = node.getId();
        if (unique.contains(nodeId)) {
            return;
        }
        unique.add(nodeId);
        if (node instanceof BillOfMaterials) {
            BillOfMaterials bom = (BillOfMaterials)node;
            wrappers.add(new IDWrapper(bom.getQueryId(), bom.getQuery()));
            BillOfMaterials.collectNodeContents(bom.getTopNode(), unique, wrappers);
        } else {
            Resolution resolution = node.getResolution();
            if (resolution != null) {
                BillOfMaterials.addIfNotAdded(resolution.getProvider(), unique, wrappers);
                BillOfMaterials.addIfNotAdded(resolution.getCSpec(), unique, wrappers);
                BillOfMaterials.addIfNotAdded(resolution, unique, wrappers);
                for (BOMNode child : node.getChildren()) {
                    BillOfMaterials.collectNodeContents(child, unique, wrappers);
                }
            }
        }
        wrappers.add(new IDWrapper(nodeId, node));
    }

    public BillOfMaterials(BOMNode topNode, ComponentQuery query, Date timestamp) {
        this.topNode = topNode;
        this.query = query;
        this.timestamp = timestamp == null ? new Date() : timestamp;
    }

    public void addMaterializationNodes(MaterializationSpecBuilder bld) throws CoreException {
        for (Resolution res : this.findAll(null)) {
            if (!res.isMaterializable()) continue;
            res.getProvider().getReaderType().addMaterializationNode(bld, res);
        }
    }

    public boolean contentEqual(BillOfMaterials other) {
        return other != null && this.topNode.equals(other.topNode);
    }

    @Override
    public List<Resolution> findAll(Set<Resolution> skipThese) throws CoreException {
        return this.getTopNode().findAll(skipThese);
    }

    public List<Resolution> findMaterializationCandidates(RMContext context, MaterializationSpec mspec) throws CoreException {
        ArrayList<Resolution> minfos = new ArrayList<Resolution>();
        this.addMaterializationCandidates(context, minfos, this.getQuery(), mspec, new HashSet<Resolution>());
        return minfos;
    }

    public BillOfMaterials fullyResolve(IProgressMonitor monitor) throws CoreException {
        return this.fullyResolve(new MainResolver(new ResolutionContext(this.getQuery())), monitor);
    }

    public BillOfMaterials fullyResolve(IResolver resolver, IProgressMonitor monitor) throws CoreException {
        return resolver.resolveRemaining(this, monitor);
    }

    @Override
    public List<BOMNode> getChildren() {
        return this.getTopNode().getChildren();
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public QualifiedDependency getQualifiedDependency() {
        return this.getTopNode().getQualifiedDependency();
    }

    @Override
    public synchronized ComponentQuery getQuery() {
        return this.query;
    }

    @Override
    public UUID getQueryId() {
        return this.query.getId();
    }

    @Override
    public ComponentRequest getRequest() {
        return this.getTopNode().getRequest();
    }

    @Override
    public Resolution getResolution() {
        return this.getTopNode().getResolution();
    }

    @Override
    public UUID getResolutionId() throws CoreException {
        return this.getTopNode().getResolutionId();
    }

    public synchronized BOMNode getResolvedNode(IComponentIdentifier identifier) throws CoreException {
        BOMNode node;
        if (this.nodeMap == null) {
            HashMap<ComponentIdentifier, BOMNode> nm = new HashMap<ComponentIdentifier, BOMNode>();
            BillOfMaterials.buildNodeMap(this.getTopNode(), nm);
            this.nodeMap = nm;
        }
        if ((node = this.nodeMap.get(identifier)) == null) {
            throw new MissingComponentException(identifier.toString());
        }
        return node;
    }

    public String getTagInfo() {
        return this.getQuery().getTagInfo();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public List<ComponentRequest> getUnresolvedList() {
        ArrayList<ComponentRequest> unresolved = new ArrayList<ComponentRequest>();
        this.topNode.addUnresolved(unresolved, new HashSet<Resolution>());
        return unresolved;
    }

    @Override
    public String getViewName() throws CoreException {
        return this.getTopNode().getViewName();
    }

    @Override
    public boolean isChild(BOMNode node) throws CoreException {
        return this.getTopNode().isChild(node);
    }

    @Override
    public boolean isFullyResolved(ComponentQuery cquery, Map<String, ? extends Object> properties) throws CoreException {
        return this.getTopNode().isFullyResolved(cquery, properties);
    }

    public boolean isFullyResolved(Map<String, ? extends Object> properties) throws CoreException {
        return this.getTopNode().isFullyResolved(this.getQuery(), properties);
    }

    @Override
    public final boolean isReferencing(BOMNode node, boolean shallow) throws CoreException {
        return this.equals(node) || this.getTopNode().isReferencing(node, shallow);
    }

    public BillOfMaterials replaceNode(BOMNode node) throws CoreException {
        return (BillOfMaterials)this.replaceNode(node, new HashMap<BOMNode, BOMNode>());
    }

    public BillOfMaterials switchContent(BillOfMaterials other) {
        if (this.topNode.equals(other.getTopNode())) {
            return this;
        }
        return new BillOfMaterials(other.getTopNode(), this.query, new Date());
    }

    public void toSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        ArrayList<IDWrapper> wrappers = new ArrayList<IDWrapper>();
        HashSet<UUID> unique = new HashSet<UUID>();
        wrappers.add(new IDWrapper(this.query.getId(), this.query));
        try {
            BillOfMaterials.collectNodeContents(this.getTopNode(), unique, wrappers);
        }
        catch (CoreException e) {
            throw new SAXException((Exception)((Object)e));
        }
        for (IDWrapper wrapper : wrappers) {
            UUIDKeyed wrapped = wrapper.getWrapped();
            if (!(wrapped instanceof Provider)) continue;
            ((Provider)wrapped).addPrefixMappings(prefixMappings);
        }
        Set pfxMappings = prefixMappings.entrySet();
        if (pfxMappings.size() > 0) {
            for (Map.Entry entry : pfxMappings) {
                receiver.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        this.addAttributes(attributesImpl);
        Utils.emitCollection((String)namespace, (String)prefix, (String)localName, (String)"idwrapper", (Attributes)attributesImpl, wrappers, (ContentHandler)receiver);
        if (pfxMappings.size() > 0) {
            for (Map.Entry pfxMapping : pfxMappings) {
                receiver.endPrefixMapping((String)pfxMapping.getKey());
            }
        }
    }

    protected void addAttributes(AttributesImpl attrs) {
        if (this.topNode != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TOP_NODE_ID, (String)this.topNode.getId().toString());
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_QUERY_ID, (String)this.query.getId().toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)DateAndTimeUtils.toISOFormat(this.timestamp));
    }

    @Override
    void addMaterializationCandidates(RMContext context, List<Resolution> resolutions, ComponentQuery cquery, MaterializationSpec mspec, Set<Resolution> perused) throws CoreException {
        this.getTopNode().addMaterializationCandidates(context, resolutions, cquery, mspec, perused);
    }

    @Override
    void collectAll(Set<Resolution> notThese, List<Resolution> all) throws CoreException {
        this.getTopNode().collectAll(notThese, all);
    }

    @Override
    BOMNode replaceNode(BOMNode node, Map<BOMNode, BOMNode> visited) throws CoreException {
        BOMNode newTop;
        BOMNode self = visited.get(this);
        if (self != null) {
            return self;
        }
        BOMNode oldTop = this.getTopNode();
        if (node instanceof BillOfMaterials && node.getQuery().equals(this.getQuery())) {
            newTop = ((BillOfMaterials)node).getTopNode();
            if (oldTop.getQualifiedDependency().equals(newTop.getQualifiedDependency())) {
                visited.put(this, node);
                return node;
            }
        }
        self = oldTop == (newTop = oldTop.replaceNode(node, visited)) ? this : BillOfMaterials.create(newTop, this.getQuery());
        visited.put(this, self);
        return self;
    }

    void wrappedToSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttributes(attrs);
        String qName = Utils.makeQualifiedName((String)prefix, (String)localName);
        receiver.startElement(namespace, localName, qName, attrs);
        receiver.endElement(namespace, localName, qName);
    }

    private synchronized BOMNode getTopNode() {
        return this.topNode;
    }
}

