/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.metadata.ISaxableStorage;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.builder.ResolutionBuilder;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Resolution
extends UUIDKeyed
implements IUUIDPersisted,
IResolution {
    public static final String ATTR_ATTRIBUTES = "attributes";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_CONTENT_TYPE = "contentType";
    public static final String ATTR_CSPEC_ID = "cspecId";
    public static final String ATTR_LAST_MODIFIED = "lastModified";
    public static final String ATTR_MATERIALIZABLE = "materializable";
    public static final String ATTR_PERSISTENT_ID = "persistentId";
    public static final String ATTR_PROVIDER_ID = "providerId";
    public static final String ATTR_QUERY_ID = "queryId";
    public static final String ATTR_REMOTE_NAME = "remoteName";
    public static final String ATTR_REPOSITORY = "repository";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_UNPACK = "unpack";
    public static final String ELEM_REQUEST = "request";
    public static final int SEQUENCE_NUMBER = 2;
    public static final String TAG = "resolution";
    private final List<String> attributes;
    private final String componentTypeId;
    private final String contentType;
    private transient CSpec cspec;
    private final long lastModified;
    private final boolean materializable;
    private final String persistentId;
    private transient Provider provider;
    private final String remoteName;
    private final String repository;
    private final ComponentRequest request;
    private final long size;
    private final boolean unpack;
    private final VersionMatch versionMatch;
    private Map<String, ? extends Object> properties;

    public Resolution(CSpec cspec, Resolution old) {
        this.cspec = cspec;
        this.request = old.getRequest();
        this.attributes = old.getAttributes();
        this.persistentId = old.getPersistentId();
        this.provider = old.getProvider();
        this.componentTypeId = old.getComponentTypeId();
        this.versionMatch = old.getVersionMatch().copyWithVersion(cspec.getVersion());
        this.materializable = old.isMaterializable();
        this.repository = old.getRepository();
        this.remoteName = old.getRemoteName();
        this.contentType = old.getContentType();
        this.lastModified = old.getLastModified();
        this.size = old.getSize();
        this.unpack = old.isUnpack();
    }

    public Resolution(CSpec cspec, String componentTypeId, VersionMatch versionMatch, Provider provider, boolean materializeable, ComponentRequest request, List<String> attributes, String persistentId, String repository, String remoteName, String contentType, long lastModified, long size, boolean unpack) {
        this.cspec = cspec;
        this.provider = provider;
        this.componentTypeId = componentTypeId;
        this.versionMatch = versionMatch;
        this.materializable = materializeable;
        this.request = request;
        this.attributes = Utils.createUnmodifiableList(attributes);
        this.persistentId = persistentId;
        this.repository = repository;
        this.remoteName = remoteName;
        this.contentType = contentType;
        this.lastModified = lastModified;
        this.size = size;
        this.unpack = unpack;
    }

    public Resolution(ResolutionBuilder bld) {
        this.attributes = Utils.createUnmodifiableList(bld.getAttributes());
        this.componentTypeId = bld.getComponentTypeId();
        this.contentType = bld.getContentType();
        this.cspec = bld.getCSpec();
        this.lastModified = bld.getLastModified();
        this.materializable = bld.isMaterializable();
        this.persistentId = bld.getPersistentId();
        this.provider = bld.getProvider();
        this.remoteName = bld.getRemoteName();
        this.repository = bld.getRepository();
        this.request = bld.getRequest().createComponentRequest();
        this.size = bld.getSize();
        this.versionMatch = bld.getVersionMatch();
        this.unpack = bld.isUnpack();
    }

    public Resolution(Version version, Resolution old) {
        this.cspec = old.getCSpec();
        this.request = old.getRequest();
        this.attributes = old.getAttributes();
        this.persistentId = old.getPersistentId();
        this.provider = old.getProvider();
        this.componentTypeId = old.getComponentTypeId();
        this.versionMatch = old.getVersionMatch().copyWithVersion(version);
        this.materializable = old.isMaterializable();
        this.repository = old.getRepository();
        this.remoteName = old.getRemoteName();
        this.contentType = old.getContentType();
        this.lastModified = old.getLastModified();
        this.size = old.getSize();
        this.unpack = old.isUnpack();
    }

    public void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        this.request.toSax(handler, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", ELEM_REQUEST);
        this.versionMatch.toSax(handler, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.versionMatch.getDefaultTag());
    }

    @Override
    public String getArtifactInfo() {
        return this.versionMatch.getArtifactInfo();
    }

    public URI getArtifactURI(RMContext context) throws CoreException {
        return this.getProvider().getReaderType().getArtifactURL(this, context);
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.getCSpec().getComponentIdentifier();
    }

    public IComponentType getComponentType() throws CoreException {
        return CorePlugin.getDefault().getComponentType(this.componentTypeId);
    }

    @Override
    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public CSpec getCSpec() {
        return this.cspec;
    }

    public UUID getCSpecId() {
        return this.cspec.getId();
    }

    public String getDefaultTag() {
        return TAG;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public VersionSelector getMatchedBranchOrTag() {
        return this.versionMatch.getBranchOrTag();
    }

    public final String getName() {
        return this.request.getName();
    }

    @Override
    public String getPersistentId() {
        return this.persistentId;
    }

    public synchronized Map<String, ? extends Object> getProperties() {
        if (this.properties == null) {
            HashMap<String, ? extends Object> props = new HashMap<String, Object>();
            props.put("buckminster.readerType", this.provider.getReaderTypeId());
            props.put("buckminster.mutable", Boolean.toString(this.provider.isMutable()));
            props.put("buckminster.source", Boolean.toString(this.provider.hasSource()));
            props.putAll(this.cspec.getComponentIdentifier().getProperties());
            this.properties = props;
        }
        return this.properties;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    public UUID getProviderId() {
        return this.provider.getId();
    }

    public ProviderMatch getProviderMatch(RMContext context) throws CoreException {
        ProviderMatch pm = new ProviderMatch(this.provider, this.getComponentType(), this.getVersionMatch(), context.getNodeQuery(this.getQualifiedDependency()));
        pm.setRepositoryURI(this.repository);
        return pm;
    }

    public final QualifiedDependency getQualifiedDependency() {
        return new QualifiedDependency(this.request, this.attributes);
    }

    @Override
    public String getReaderTypeId() {
        return this.getProvider().getReaderTypeId();
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public final ComponentRequest getRequest() {
        return this.request;
    }

    @Override
    public Filter getResolutionFilter() {
        return this.getProvider().getResolutionFilter();
    }

    @Override
    public String getSelectedRevision() {
        return this.versionMatch.getRevision();
    }

    @Override
    public Date getSelectedTimestamp() {
        return this.getVersionMatch().getTimestamp();
    }

    public long getSize() {
        return this.size;
    }

    public final Version getVersion() {
        return this.versionMatch.getVersion();
    }

    public final VersionRange getVersionDesignator() throws CoreException {
        return this.request.getVersionRange();
    }

    @Override
    public VersionMatch getVersionMatch() {
        return this.versionMatch;
    }

    public boolean isDesignatedBy(ComponentRequest rq) throws CoreException {
        if (!rq.getName().equals(this.request.getName())) {
            return false;
        }
        String componentType = rq.getComponentTypeID();
        if (componentType != null && !componentType.equals(this.request.getComponentTypeID())) {
            return false;
        }
        VersionRange vd = rq.getVersionRange();
        return vd == null ? true : vd.isIncluded(this.getVersion());
    }

    public boolean isFilterMatchFor(NodeQuery query) {
        return this.isFilterMatchFor(query, null);
    }

    public boolean isFilterMatchFor(NodeQuery query, Filter[] failingFilter) {
        Filter cspecFilter = this.getCSpec().getFilter();
        if (cspecFilter == null) {
            return true;
        }
        Map<String, String[]> attributeUsageMap = query.getContext().getFilterAttributeUsageMap();
        Map<String, ? extends Object> queryProps = query.getProperties();
        cspecFilter.addConsultedAttributes(attributeUsageMap);
        if (cspecFilter.matchCase(queryProps)) {
            return true;
        }
        if (failingFilter != null) {
            failingFilter[0] = cspecFilter;
        }
        return false;
    }

    @Override
    public boolean isMaterializable() {
        return this.materializable;
    }

    public boolean isMaterialized(IPath location) throws CoreException {
        try {
            IPath myLocation = this.getCSpec().getComponentLocation();
            return location.equals((Object)myLocation);
        }
        catch (MissingComponentException e) {
            return false;
        }
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getResolutions().contains(this);
    }

    @Override
    public boolean isUnpack() {
        return this.unpack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(StorageManager sm) throws CoreException {
        WorkspaceInfo.updateResolutionCache(this.getComponentIdentifier(), null);
        ISaxableStorage<Resolution> iSaxableStorage = sm.getResolutions();
        synchronized (iSaxableStorage) {
            sm.getResolutions().removeElement(this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(StorageManager sm) throws CoreException {
        WorkspaceInfo.updateResolutionCache(this.getComponentIdentifier(), this);
        this.cspec.store(sm);
        this.provider.store(sm);
        ISaxableStorage<Resolution> iSaxableStorage = sm.getResolutions();
        synchronized (iSaxableStorage) {
            sm.getResolutions().putElement(this);
        }
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.eclipse.org/buckminster/MetaData-1.0", "md", this.getDefaultTag());
        receiver.endDocument();
    }

    public void toSax(ContentHandler handler, String namespace, String prefix, String localName) throws SAXException {
        handler.startPrefixMapping("md", "http://www.eclipse.org/buckminster/MetaData-1.0");
        super.toSax(handler, namespace, prefix, localName);
        handler.endPrefixMapping("md");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Messages.Name);
        result.append(this.request.getName());
        result.append(", ");
        this.versionMatch.toString(result);
        return result.toString();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CSPEC_ID, (String)this.cspec.getId().toString());
        String tmp = TextUtils.concat(this.attributes, ",");
        if (tmp != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTES, (String)tmp);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MATERIALIZABLE, (String)(this.materializable ? "true" : "false"));
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PROVIDER_ID, (String)this.provider.getId().toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REPOSITORY, (String)this.repository);
        if (this.componentTypeId != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.componentTypeId);
        }
        if (this.persistentId != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PERSISTENT_ID, (String)this.persistentId);
        }
        if (this.remoteName != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REMOTE_NAME, (String)this.remoteName);
        }
        if (this.contentType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CONTENT_TYPE, (String)this.contentType);
        }
        if (this.lastModified != -1L) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LAST_MODIFIED, (String)Long.toString(this.lastModified));
        }
        if (this.size != -1L) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SIZE, (String)Long.toString(this.size));
        }
        if (this.unpack) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_UNPACK, (String)"true");
        }
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/MetaData-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "md";
    }
}

