/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.ElementRefHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ResolvedNodeHandler
extends BomNodeHandler
implements ChildPoppedListener {
    public static final String TAG = "resolvedNode";
    private UUID resolutionId;
    private final ArrayList<UUID> children = new ArrayList();
    private final ElementRefHandler childHandler = new ElementRefHandler((AbstractHandler)this, "child");

    ResolvedNodeHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXParseException {
        if (child == this.childHandler) {
            this.children.add(this.childHandler.getRefId());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ElementRefHandler ch = this.childHandler.getTAG().equals(localName) ? this.childHandler : super.createHandler(uri, localName, attrs);
        return ch;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.resolutionId = UUID.fromString(this.getStringValue(attrs, "resolutionId"));
        this.children.clear();
    }

    @Override
    BOMNode getDepNode() throws SAXException {
        ArrayList<BOMNode> childNodes = new ArrayList<BOMNode>(this.children.size());
        for (UUID childId : this.children) {
            childNodes.add((BOMNode)this.getWrapped(childId));
        }
        try {
            return new ResolvedNode((Resolution)this.getWrapped(this.resolutionId), childNodes);
        }
        catch (ClassCastException e) {
            throw new SAXParseException(NLS.bind((String)Messages.Wrapper_0_does_not_wrap_resolution, (Object)this.resolutionId), this.getDocumentLocator());
        }
    }
}

