/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.ArrayList;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.metadata.parser.AttributeRefHandler;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class UnresolvedNodeHandler
extends BomNodeHandler
implements ChildPoppedListener {
    public static final String TAG = "unresolvedNode";
    private ComponentRequest componentRequest;
    private final ComponentRequestHandler requestHandler = new ComponentRequestHandler((AbstractHandler)this, new ComponentRequestBuilder());
    private ArrayList<String> attributes;
    private AttributeRefHandler attributeRefHandler;

    UnresolvedNodeHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXParseException {
        if (child == this.requestHandler) {
            this.componentRequest = this.requestHandler.getBuilder().createComponentRequest();
        } else if (child == this.attributeRefHandler) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(this.attributeRefHandler.getName());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch;
        if ("component".equals(localName)) {
            ch = this.requestHandler;
        } else if ("attribute".equals(localName)) {
            if (this.attributeRefHandler == null) {
                this.attributeRefHandler = new AttributeRefHandler((AbstractHandler)this);
            }
            ch = this.attributeRefHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.componentRequest = null;
    }

    @Override
    BOMNode getDepNode() {
        return new UnresolvedNode(new QualifiedDependency(this.componentRequest, this.attributes));
    }
}

