/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.IMaterializationSpec;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.core.mspec.builder.MaterializationNodeBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MaterializationSpecBuilder
extends MaterializationDirectiveBuilder
implements IMaterializationSpec {
    private final List<MaterializationNodeBuilder> nodes = new ArrayList<MaterializationNodeBuilder>();
    private String shortDesc;
    private String name;
    private String url;
    private URL contextURL;

    public MaterializationNodeBuilder addNodeBuilder() {
        MaterializationNodeBuilder node = new MaterializationNodeBuilder();
        this.nodes.add(node);
        return node;
    }

    @Override
    public void clear() {
        super.clear();
        this.name = null;
        this.shortDesc = null;
        this.url = null;
        this.contextURL = null;
        this.nodes.clear();
    }

    public MaterializationSpec createMaterializationSpec() {
        return new MaterializationSpec(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter.isAssignableFrom(MaterializationSpec.class)) {
            return this.createMaterializationSpec();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public URL getContextURL() {
        return this.contextURL;
    }

    @Override
    public IMaterializationNode getMatchingNode(IComponentName cName) {
        return this.getMatchingNodeBuilder(cName);
    }

    @Override
    public IMaterializationNode getMatchingNode(Resolution res) {
        return this.getMatchingNodeBuilder(res);
    }

    public MaterializationNodeBuilder getMatchingNodeBuilder(IComponentName cName) {
        String cn = cName.getName();
        for (MaterializationNodeBuilder aNode : this.nodes) {
            String matchingCType;
            Pattern pattern = aNode.getNamePattern();
            if (pattern == null || !pattern.matcher(cn).find() || (matchingCType = aNode.getComponentTypeID()) != null && !matchingCType.equals(cName.getComponentTypeID())) continue;
            return aNode;
        }
        return null;
    }

    public MaterializationNodeBuilder getMatchingNodeBuilder(Resolution res) {
        Map<String, ? extends Object> props = null;
        ComponentIdentifier ci = res.getComponentIdentifier();
        for (MaterializationNodeBuilder aNode : this.nodes) {
            String matchingCType;
            Pattern pattern = aNode.getNamePattern();
            if (pattern != null && !pattern.matcher(ci.getName()).find() || (matchingCType = aNode.getComponentTypeID()) != null && !matchingCType.equals(ci.getComponentTypeID())) continue;
            Filter filter = aNode.getFilter();
            if (filter != null) {
                if (props == null) {
                    props = res.getProperties();
                }
                if (!filter.matches(props)) continue;
            }
            return aNode;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<MaterializationNodeBuilder> getNodeBuilders() {
        return this.nodes;
    }

    @Override
    public List<? extends IMaterializationNode> getNodes() {
        return this.getNodeBuilders();
    }

    @Override
    public URL getResolvedURL() {
        return URLUtils.resolveURL((URL)this.contextURL, (String)this.url);
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public void initFrom(IMaterializationSpec mspec) {
        super.initFrom(mspec);
        this.name = mspec.getName();
        this.shortDesc = mspec.getShortDesc();
        this.url = mspec.getURL();
        this.contextURL = mspec.getContextURL();
        for (IMaterializationNode iMaterializationNode : mspec.getNodes()) {
            MaterializationNodeBuilder nodeBuilder = new MaterializationNodeBuilder();
            nodeBuilder.initFrom(iMaterializationNode);
            this.nodes.add(nodeBuilder);
        }
    }

    public void setContextURL(URL contextURL) {
        this.contextURL = contextURL;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        MaterializationSpec mspec = new MaterializationSpec(this);
        mspec.toSax(receiver);
    }
}

