/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.prefs;

import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class MaxParallelResolutions
extends BasicPreferenceHandler {
    public String get(String defaultValue) throws CoreException {
        return super.get(Integer.toString(4));
    }

    public void set(String prefValue) throws BackingStoreException {
        try {
            int maxJobs = Integer.parseInt(prefValue);
            if (maxJobs > 0 && maxJobs <= 20) {
                super.set(prefValue);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format(NLS.bind((String)Messages._0_illegal_value_for_maxParallelResolutions, (Object)prefValue), new Object[0]));
    }

    public void unset() throws BackingStoreException {
        this.set(Integer.toString(4));
    }
}

