/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AdvisorNodeHandler
extends PropertyManagerHandler {
    public static final String TAG = "advisorNode";
    private DocumentationHandler documentationHandler;
    private AdvisorNodeBuilder builder;

    public AdvisorNodeHandler(AbstractHandler parent) {
        super(parent, TAG);
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.documentationHandler) {
            this.builder.setDocumentation(this.documentationHandler.createDocumentation());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        DocumentationHandler ch;
        if ("documentation".equals(localName)) {
            if (this.documentationHandler == null) {
                this.documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.documentationHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.builder.getProperties();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        String tmp;
        this.builder = new AdvisorNodeBuilder();
        this.builder.setNamePattern(this.getOptionalPatternValue(attrs, "namePattern"));
        this.builder.setComponentTypeID(this.getComponentType(attrs));
        String filterStr = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"filter");
        if (filterStr != null) {
            try {
                this.builder.setFilter(FilterFactory.newInstance((String)filterStr));
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        if ((tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"overlayFolder")) != null) {
            try {
                this.builder.setOverlayFolder(URLUtils.normalizeToURL((String)tmp));
            }
            catch (IOException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
        if ((tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"mutableLevel")) != null) {
            this.builder.setMutableLevel(MutableLevel.valueOf(tmp));
        }
        if ((tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"sourceLevel")) != null) {
            this.builder.setSourceLevel(SourceLevel.valueOf(tmp));
        }
        try {
            this.builder.setVersionOverride(VersionHelper.parseVersionRangeAttributes(attrs, "versionOverride", "versionOverrideType"));
        }
        catch (CoreException e) {
            throw new SAXParseException(e.toString(), this.getDocumentLocator());
        }
        tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"branchTagPath");
        if (tmp != null) {
            try {
                this.builder.setBranchTagPath(VersionSelector.fromPath(tmp));
            }
            catch (IllegalArgumentException e) {
                throw new SAXParseException(e.toString(), this.getDocumentLocator());
            }
        }
        this.builder.setRevision(AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"revision"));
        tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"timestamp");
        if (tmp != null) {
            try {
                this.builder.setTimestamp(DateAndTimeUtils.fromISOFormat(tmp));
            }
            catch (ParseException e) {
                throw new SAXParseException(e.toString(), this.getDocumentLocator());
            }
        }
        if ((tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"attributes")) != null) {
            StringTokenizer tokens = new StringTokenizer(tmp, ",");
            while (tokens.hasMoreElements()) {
                this.builder.addAttribute(tokens.nextToken());
            }
        }
        if ((tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"resolutionPrio")) != null) {
            int max = IAdvisorNode.DEFAULT_RESOLUTION_PRIO.length;
            int[] prios = new int[max];
            try {
                int idx = 0;
                StringTokenizer tokens = new StringTokenizer(tmp, ",");
                while (tokens.hasMoreElements()) {
                    if (idx == max) {
                        ++idx;
                        break;
                    }
                    prios[idx++] = Integer.parseInt(tokens.nextToken());
                }
                if (idx != max) {
                    throw new SAXParseException(Messages.Incorrect_number_of_resolution_priorites, this.getDocumentLocator());
                }
            }
            catch (NumberFormatException e) {
                throw new SAXParseException(e.toString(), this.getDocumentLocator());
            }
            this.builder.setResolutionPrio(prios);
        }
        this.builder.setPrune(AdvisorNodeHandler.getOptionalBooleanValue((Attributes)attrs, (String)"prune", (boolean)false));
        this.builder.setAllowCircularDependency(AdvisorNodeHandler.getOptionalBooleanValue((Attributes)attrs, (String)"allowCircularDependency", (boolean)false));
        this.builder.setSkipComponent(AdvisorNodeHandler.getOptionalBooleanValue((Attributes)attrs, (String)"skipComponent", (boolean)false));
        tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"useTargetPlatform");
        if (tmp == null) {
            tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"useInstalled");
        }
        this.builder.setUseTargetPlatform(tmp == null || "true".equalsIgnoreCase(tmp));
        tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"useWorkspace");
        if (tmp == null) {
            tmp = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"useProject");
        }
        this.builder.setUseWorkspace(tmp == null || "true".equalsIgnoreCase(tmp));
        this.builder.setUseMaterialization(AdvisorNodeHandler.getOptionalBooleanValue((Attributes)attrs, (String)"useMaterialization", (boolean)true));
        this.builder.setUseRemoteResolution(AdvisorNodeHandler.getOptionalBooleanValue((Attributes)attrs, (String)"useRemoteResolution", (boolean)true));
        this.builder.setSystemDiscovery(AdvisorNodeHandler.getOptionalBooleanValue((Attributes)attrs, (String)"systemDiscovery", (boolean)true));
        String spacePath = AdvisorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"spacePath");
        if (spacePath != null) {
            this.logAttributeDeprecation(TAG, "spacePath", "property buckminster.spacePath=");
            this.getProperties().put("buckminster.spacepath", spacePath);
        }
    }

    AdvisorNodeBuilder getAdvisorNodeBuilder() {
        return this.builder;
    }
}

