/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.File;
import java.io.IOException;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

public abstract class AbstractReader
implements IComponentReader {
    private final ProviderMatch providerMatch;
    private final IReaderType readerType;

    protected AbstractReader(IReaderType readerType, ProviderMatch providerMatch) {
        this.providerMatch = providerMatch;
        this.readerType = readerType;
    }

    @Override
    public boolean canMaterialize() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public IComponentType getComponentType() {
        return this.providerMatch.getComponentType();
    }

    @Override
    public IConnectContext getConnectContext() {
        return this.providerMatch.getConnectContext();
    }

    @Override
    public File getLocation() throws CoreException {
        return null;
    }

    @Override
    public NodeQuery getNodeQuery() {
        return this.providerMatch.getNodeQuery();
    }

    @Override
    public ProviderMatch getProviderMatch() {
        return this.providerMatch;
    }

    @Override
    public IReaderType getReaderType() {
        return this.readerType;
    }

    @Override
    public IVersionConverter getVersionConverter() throws CoreException {
        return this.getProviderMatch().getVersionConverter();
    }

    @Override
    public boolean isFileSystemReader() {
        return false;
    }

    @Override
    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.getNodeQuery().logDecision(request, decisionType, args);
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.getNodeQuery().logDecision(decisionType, args);
    }

    protected void copyOverlay(IPath destination, IProgressMonitor monitor) throws CoreException {
    }

    protected File createTempFile() throws IOException {
        return File.createTempFile(String.valueOf(this.getReaderType().getId()) + '-', ".tmp");
    }
}

