/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ZipArchiveReader
extends AbstractCatalogReader {
    private final IFileReader zipFileReader;

    public ZipArchiveReader(IFileReader fileReader) {
        super(fileReader.getReaderType(), fileReader.getProviderMatch());
        this.zipFileReader = fileReader;
    }

    public IComponentReader getFileReader() {
        return this.zipFileReader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        zi = null;
        try {
            zi = new ZipInputStream(this.zipFileReader.open(monitor));
            ** GOTO lbl-1000
        }
        catch (FileNotFoundException e) {
            IOUtils.close(zi);
            return false;
            catch (IOException e) {
                try {
                    throw BuckminsterException.wrap((Throwable)e);
                }
                catch (Throwable var5_7) {
                    IOUtils.close(zi);
                    throw var5_7;
                }
            }
        }
lbl14:
        // 1 sources

        while (true) {
            IOUtils.close((Closeable)zi);
            return true;
        }
lbl-1000:
        // 2 sources

        {
            ** while ((ze = zi.getNextEntry()) != null)
        }
lbl-1000:
        // 1 sources

        {
            if (!ze.getName().equals(fileName)) continue;
            ** continue;
lbl20:
            // 1 sources

            ** GOTO lbl14
        }
lbl21:
        // 1 sources

        IOUtils.close((Closeable)zi);
        return false;
    }

    @Override
    protected void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
        block8: {
            ZipInputStream zi = null;
            try {
                try {
                    ZipEntry ze;
                    zi = new ZipInputStream(this.zipFileReader.open(monitor));
                    while ((ze = zi.getNextEntry()) != null) {
                        String name = ze.getName();
                        if (name.endsWith("/")) {
                            name = name.substring(name.length() - 1);
                        }
                        if (name.indexOf(47, 1) >= 0) continue;
                        if (ze.isDirectory()) {
                            name = String.valueOf(name) + "/";
                        }
                        files.add(name);
                    }
                }
                catch (IOException iOException) {
                    IOUtils.close(zi);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(zi);
                throw throwable;
            }
            IOUtils.close((Closeable)zi);
        }
    }

    @Override
    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(Messages.Cannot_materialize);
    }

    @Override
    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        T result = null;
        Throwable throwable = null;
        Object var7_7 = null;
        try (ZipInputStream zi = new ZipInputStream(this.zipFileReader.open(monitor));){
            ZipEntry ze;
            while ((ze = zi.getNextEntry()) != null) {
                if (!ze.getName().equals(fileName)) continue;
                result = consumer.consumeStream(this, fileName, zi, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            if (result == null) {
                throw new FileNotFoundException(fileName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }
}

