/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.net.URL;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolverBackchannel;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;

public class NodeQuery
implements Comparator<VersionMatch>,
IResolverBackchannel {
    private final RMContext context;
    private final Map<String, ? extends Object> properties;
    private final QualifiedDependency qDep;
    private transient IComponentType componentType;

    public NodeQuery(NodeQuery query, Map<String, ? extends Object> additionalProperties) {
        this(query, additionalProperties, true);
    }

    public NodeQuery(NodeQuery query, Map<String, ? extends Object> additionalProperties, boolean additionalPrioritized) {
        this.context = query.getContext();
        this.qDep = query.getQualifiedDependency();
        Map<String, ? extends Object> qprops = query.getProperties();
        if (additionalProperties.isEmpty()) {
            this.properties = qprops;
        } else {
            ExpandingProperties<? extends Object> propUnion = new ExpandingProperties<Object>(qprops.size() + additionalProperties.size());
            if (additionalPrioritized) {
                propUnion.putAll(qprops, true);
                propUnion.putAll(additionalProperties);
            } else {
                propUnion.putAll(additionalProperties, true);
                propUnion.putAll(qprops);
            }
            this.properties = propUnion;
        }
    }

    public NodeQuery(RMContext context, ComponentRequest request, Set<String> attributes) {
        this(context, new QualifiedDependency(request, attributes));
    }

    public NodeQuery(RMContext context, QualifiedDependency qDep) {
        this.context = context;
        this.qDep = qDep;
        this.properties = context.getProperties(qDep.getRequest());
    }

    public NodeQuery addDependencyQualification(QualifiedDependency newQDep) throws CoreException {
        QualifiedDependency mqDep = this.qDep.mergeDependency(newQDep);
        return this.qDep == mqDep ? this : this.context.getNodeQuery(mqDep);
    }

    public boolean allowCircularDependency() throws CoreException {
        return this.getComponentQuery().allowCircularDependency(this.getComponentRequest(), this.context);
    }

    @Override
    public int compare(VersionMatch vm1, VersionMatch vm2) {
        if (vm1 == vm2) {
            return 0;
        }
        int cmp = 0;
        String revision = this.getRevision();
        if (vm1.satisfiesRevision(revision)) {
            if (!vm2.satisfiesRevision(revision)) {
                cmp = -1;
            }
        } else if (vm2.satisfiesRevision(revision)) {
            cmp = 1;
        } else {
            return 0;
        }
        if (cmp != 0) {
            return cmp;
        }
        Date timestamp = this.getTimestamp();
        Date vm1Ts = vm1.getTimestamp();
        Date vm2Ts = vm2.getTimestamp();
        if (timestamp != null) {
            if (vm1Ts != null && timestamp.compareTo(vm1Ts) >= 0) {
                if (vm2Ts == null || timestamp.compareTo(vm2Ts) < 0) {
                    cmp = 1;
                }
            } else if (vm2Ts != null && timestamp.compareTo(vm2Ts) >= 0) {
                cmp = -1;
            } else {
                return 0;
            }
        }
        if (cmp != 0) {
            return cmp;
        }
        int[] prio = this.getResolutionPrio();
        int idx = 0;
        while (idx < prio.length) {
            switch (prio[idx]) {
                case 2: {
                    cmp = this.compareSelectors(vm1, vm2);
                    break;
                }
                default: {
                    cmp = this.compareVersions(vm1, vm2);
                }
            }
            if (cmp != 0) {
                return cmp;
            }
            ++idx;
        }
        String vm1Str = vm1.getRevision();
        String vm2Str = vm2.getRevision();
        if (vm1Str != null && vm2Str != null && !vm1Str.equals(vm2Str)) {
            try {
                return Long.parseLong(vm1Str) < Long.parseLong(vm2Str) ? -1 : 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (vm1Ts != null && vm2Ts != null) {
            cmp = vm1Ts.compareTo(vm2Ts);
        }
        return cmp;
    }

    public IAttribute[] getAttributes(CSpec cspec) throws CoreException {
        return cspec.getAttributes(this.getRequiredAttributes());
    }

    public VersionSelector[] getBranchTagPath() {
        return this.getComponentQuery().getBranchTagPath(this.getComponentRequest(), this.context);
    }

    public final ComponentQuery getComponentQuery() {
        return this.context.getComponentQuery();
    }

    public final ComponentRequest getComponentRequest() {
        return this.qDep.getRequest();
    }

    public synchronized IComponentType getComponentType() {
        if (this.componentType == null) {
            try {
                this.componentType = this.getComponentRequest().getComponentType();
            }
            catch (CoreException e) {
                throw new IllegalStateException(Messages.Unable_to_obtain_component_type, e);
            }
        }
        return this.componentType;
    }

    public RMContext getContext() {
        return this.context;
    }

    public long getNumericRevision() {
        String revision = this.getRevision();
        return revision == null ? -1L : Long.parseLong(revision);
    }

    public final URL getOverlayFolder() {
        return this.getComponentQuery().getOverlayFolder(this.getComponentRequest(), this.context);
    }

    public Map<String, ? extends Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String mapName) {
        return this.getProperties().get(mapName);
    }

    public ProviderScore getProviderScore(boolean mutable, boolean source) {
        return this.getComponentQuery().getProviderScore(this.getComponentRequest(), mutable, source, this.context);
    }

    public QualifiedDependency getQualifiedDependency() {
        return this.qDep;
    }

    public List<String> getRequiredAttributes() {
        return this.getComponentQuery().getAttributes(this.getComponentRequest(), this.context);
    }

    public ResolutionContext getResolutionContext() {
        if (this.context instanceof ResolutionContext) {
            return (ResolutionContext)this.context;
        }
        throw new IllegalStateException(Messages.ResolutionContext_requested_during_Materialization);
    }

    public int[] getResolutionPrio() {
        return this.getComponentQuery().getResolutionPrio(this.getComponentRequest(), this.context);
    }

    public String getRevision() {
        return this.getComponentQuery().getRevision(this.getComponentRequest(), this.context);
    }

    public Date getTimestamp() {
        return this.getComponentQuery().getTimestamp(this.getComponentRequest(), this.context);
    }

    public VersionRange getVersionRange() {
        ComponentRequest request = this.getComponentRequest();
        VersionRange vds = this.getComponentQuery().getVersionOverride(request, this.context);
        if (vds == null) {
            vds = request.getVersionRange();
        }
        if (vds == null) {
            return vds;
        }
        IComponentType ctype = this.getComponentType();
        if (ctype == null && VersionHelper.getVersionType(vds.getMinimum()).equals("Triplet")) {
            try {
                ctype = CorePlugin.getDefault().getComponentType("maven");
            }
            catch (CoreException e) {
                return vds;
            }
        }
        return ctype == null ? vds : ctype.getTypeSpecificDesignator(vds);
    }

    public boolean isMatch(Version version, VersionSelector branchOrTag) {
        if (!this.isMatch(branchOrTag)) {
            return false;
        }
        VersionRange versionRange = this.getVersionRange();
        if (versionRange != null && !versionRange.isIncluded(version)) {
            this.logDecision(ResolverDecisionType.VERSION_REJECTED, version, NLS.bind((String)Messages.Not_designated_by_0, (Object)versionRange));
            return false;
        }
        return true;
    }

    public boolean isMatch(VersionMatch versionMatch) {
        if (versionMatch == null) {
            versionMatch = VersionMatch.DEFAULT;
        }
        return this.isMatch(versionMatch.getVersion(), versionMatch.getBranchOrTag());
    }

    public boolean isMatch(VersionSelector branchOrTag) {
        VersionSelector[] branchTagPath = this.getBranchTagPath();
        if (branchTagPath.length > 0) {
            if (branchOrTag == null) {
                branchOrTag = VersionSelector.branch("main");
            }
            if (VersionSelector.indexOf(branchTagPath, branchOrTag) < 0) {
                this.logDecision(branchOrTag == null || branchOrTag.getType() == 0 ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, NLS.bind((String)Messages.Not_in_path_0, (Object)VersionSelector.toString(branchTagPath)));
                return false;
            }
        }
        return true;
    }

    public boolean isPrune() {
        return this.getComponentQuery().isPrune(this.getComponentRequest(), this.context);
    }

    @Override
    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.getResolutionContext().logDecision(request, decisionType, args);
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.getResolutionContext().logDecision(this.getComponentRequest(), decisionType, args);
    }

    public boolean skipComponent() {
        return this.getComponentQuery().skipComponent(this.getComponentRequest(), this.context);
    }

    public String toString() {
        return "Query for: " + this.qDep;
    }

    public boolean useMaterialization() {
        return this.getComponentQuery().useMaterialization(this.getComponentRequest(), this.context);
    }

    public boolean useResolutionService() {
        return this.getComponentQuery().useResolutionService(this.getComponentRequest(), this.context);
    }

    public boolean useTargetPlatform() {
        return this.getComponentQuery().useTargetPlatform(this.getComponentRequest(), this.context);
    }

    public boolean useWorkspace() {
        return this.getComponentQuery().useWorkspace(this.getComponentRequest(), this.context);
    }

    private int compareSelectors(VersionMatch vm1, VersionMatch vm2) {
        int cmp = 0;
        VersionSelector[] branchTagPath = this.getBranchTagPath();
        if (branchTagPath.length > 0) {
            int v1idx = VersionSelector.indexOf(branchTagPath, vm1.getBranchOrTag());
            int v2idx = VersionSelector.indexOf(branchTagPath, vm2.getBranchOrTag());
            if (v1idx >= 0) {
                cmp = v2idx >= 0 ? (v1idx < v2idx ? 1 : (v1idx == v2idx ? 0 : -1)) : 1;
            } else if (v2idx >= 0) {
                cmp = -1;
            }
        }
        return cmp;
    }

    private int compareVersions(VersionMatch vm1, VersionMatch vm2) {
        Version v1 = vm1.getVersion();
        Version v2 = vm2.getVersion();
        VersionRange vd = this.getVersionRange();
        if (vd != null) {
            if (v1 != null && !vd.isIncluded(v1)) {
                v1 = null;
            }
            if (v2 != null && !vd.isIncluded(v2)) {
                v2 = null;
            }
        }
        int cmp = 0;
        if (v1 == null) {
            if (v2 != null) {
                cmp = -1;
            }
        } else {
            cmp = v2 == null ? 1 : v1.compareTo((Object)v2);
        }
        return cmp;
    }
}

