/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Matcher
extends AbstractSaxableElement {
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_RESOLUTION_FILTER = "resolutionFilter";
    private final ResourceMap owner;
    private final Pattern pattern;
    private final Filter resolutionFilter;

    public Matcher(ResourceMap owner, String pattern, Filter resolutionFilter) {
        this.owner = owner;
        this.pattern = pattern == null ? null : Pattern.compile(pattern);
        this.resolutionFilter = resolutionFilter;
    }

    public final ResourceMap getOwner() {
        return this.owner;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public Filter getResolutionFilter() {
        return this.resolutionFilter;
    }

    public boolean isFilterMatchFor(NodeQuery query, Filter[] failingFilter) {
        if (this.resolutionFilter == null) {
            return true;
        }
        Map<String, String[]> attributeUsageMap = query.getContext().getFilterAttributeUsageMap();
        Filter resFilter = this.getResolutionFilter();
        Map<String, ? extends Object> props = query.getProperties();
        this.resolutionFilter.addConsultedAttributes(attributeUsageMap);
        if (this.resolutionFilter.matchCase(props)) {
            return true;
        }
        if (failingFilter != null) {
            failingFilter[0] = resFilter;
        }
        return false;
    }

    public final boolean matches(String componentName) {
        return this.pattern == null || this.pattern.matcher(componentName).find();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.pattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATTERN, (String)this.pattern.toString());
        }
    }
}

