/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.Locator;
import org.eclipse.buckminster.core.rmap.model.Redirect;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapHandler;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class MatcherHandler
extends ExtensionAwareHandler {
    private String pattern;
    Filter resolutionFilter;

    public MatcherHandler(AbstractHandler parent) {
        super(parent);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.pattern = MatcherHandler.getOptionalStringValue((Attributes)attrs, (String)"pattern");
        String resFilter = MatcherHandler.getOptionalStringValue((Attributes)attrs, (String)"resolutionFilter");
        if (resFilter != null) {
            try {
                this.resolutionFilter = FilterFactory.newInstance((String)resFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        } else {
            this.resolutionFilter = null;
        }
    }

    final String getPattern() {
        return this.pattern;
    }

    final ResourceMap getResourceMap() {
        return ((ResourceMapHandler)this.getParentHandler()).getResourceMap();
    }

    static class LocatorHandler
    extends MatcherHandler {
        static final String TAG = "locator";

        public LocatorHandler(AbstractHandler parent) {
            super(parent);
        }

        @Override
        public void handleAttributes(Attributes attrs) throws SAXException {
            super.handleAttributes(attrs);
            ResourceMap rmap = this.getResourceMap();
            rmap.addMatcher(new Locator(rmap, this.getPattern(), this.getStringValue(attrs, "searchPathRef"), this.resolutionFilter, LocatorHandler.getOptionalBooleanValue((Attributes)attrs, (String)"failOnError", (boolean)true)));
        }
    }

    static class RedirectHandler
    extends MatcherHandler {
        static final String TAG = "redirect";

        public RedirectHandler(AbstractHandler parent) {
            super(parent);
        }

        @Override
        public void handleAttributes(Attributes attrs) throws SAXException {
            super.handleAttributes(attrs);
            ResourceMap rmap = this.getResourceMap();
            String href = this.getStringValue(attrs, "href");
            rmap.addMatcher(new Redirect(rmap, this.getPattern(), this.resolutionFilter, href));
        }
    }
}

