/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.reader.AbstractReaderType;
import org.eclipse.buckminster.core.version.AbstractQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;

public class RevisionQualifierGenerator
extends AbstractQualifierGenerator {
    public static String FORMAT_PROPERTY = "generator.lastRevision.format";
    public static String DEFAULT_FORMAT = "r{0,number,##################}";

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Version generateQualifier(IActionContext context, ComponentIdentifier cid, List<ComponentIdentifier> dependencies) throws CoreException {
        currentVersion = cid.getVersion();
        if (currentVersion == null) {
            return null;
        }
        try {
            location = WorkspaceInfo.getComponentLocation(cid);
            readerType = AbstractReaderType.getTypeForResource((IResource)WorkspaceInfo.getProject(cid));
            if (readerType == null) {
                return currentVersion;
            }
            revision = readerType.getLastRevision(location.toFile(), context.getCancellationMonitor());
            if (revision == -1L) {
                return currentVersion;
            }
            props = context.getProperties();
            format = (String)props.get(RevisionQualifierGenerator.FORMAT_PROPERTY);
            if (format == null) {
                format = RevisionQualifierGenerator.DEFAULT_FORMAT;
            }
            subBuildId = false;
            mf = new MessageFormat(format);
            for (IComponentIdentifier dependency : dependencies) {
                block17: {
                    depVer = dependency.getVersion();
                    if (depVer == null || (qualifier = VersionHelper.getQualifier(depVer)) == null) continue;
                    depRev = 0L;
                    try {
                        depRev = ((Number)mf.parse(qualifier)[0]).longValue();
                        break block17;
                    }
                    catch (Exception e) {
                        tmp = qualifier;
                        lastDash = tmp.lastIndexOf(45);
                        ** while (lastDash > 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        tmp = tmp.substring(0, lastDash);
                        try {
                            depRev = ((Number)mf.parse(tmp)[0]).longValue();
                            subBuildId = true;
                            break;
                        }
                        catch (Exception e2) {
                            lastDash = tmp.lastIndexOf(45);
                        }
                        continue;
                    }
                }
                if (depRev <= revision) continue;
                revision = depRev;
            }
            buildId = (String)props.get("build.id");
            newQual = mf.format(new Object[]{new Long(revision)});
            if (buildId != null && subBuildId) {
                newQual = String.valueOf(newQual) + '-' + buildId;
            }
            newQual = VersionHelper.getQualifier(currentVersion).replace("qualifier", newQual);
            newVersion = VersionHelper.replaceQualifier(currentVersion, newQual);
            if (buildId == null || subBuildId) {
                return newVersion;
            }
            prevIU = this.obtainFromReferenceRepo(cid, null);
            if (prevIU == null) {
                return newVersion;
            }
            oldBuildId = prevIU.getProperty("buckminster.build.id");
            if (oldBuildId == null || oldBuildId.equals(buildId)) {
                return newVersion;
            }
            oldVer = prevIU.getVersion();
            oldQual = VersionHelper.getQualifier(oldVer);
            if (oldQual.equals(newQual) || oldQual.startsWith(newQual) && oldQual.charAt(newQual.length()) == '-') {
                newQual = String.valueOf(newQual) + '-' + buildId;
                newQual = VersionHelper.getQualifier(currentVersion).replace("qualifier", newQual);
                newVersion = VersionHelper.replaceQualifier(currentVersion, newQual);
            }
            return newVersion;
        }
        catch (MissingComponentException e) {
            return currentVersion;
        }
    }
}

