/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.policy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.buckminster.download.ICache;
import org.eclipse.buckminster.download.IFetchPolicy;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.CacheImpl;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractFetchPolicy
implements IFetchPolicy {
    private final ICache cache;

    protected static void safeRename(File sourceFile, File destFile) throws CoreException {
        File toDelete = null;
        if (destFile.exists()) {
            toDelete = new File(String.valueOf(destFile.getPath()) + ".old");
            if (toDelete.exists()) {
                toDelete.delete();
            }
            if (!destFile.renameTo(toDelete)) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_rename_0, (Object)destFile), (Object[])new Object[0]);
            }
        }
        if (sourceFile.renameTo(destFile)) {
            if (toDelete != null) {
                toDelete.delete();
            }
        } else {
            if (toDelete != null) {
                toDelete.renameTo(destFile);
            }
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_rename_temp_0, (Object)destFile), (Object[])new Object[0]);
        }
    }

    protected AbstractFetchPolicy(ICache cache) {
        this.cache = cache;
    }

    protected ICache getCache() {
        return this.cache;
    }

    protected File getFileInfoFile(URL url) {
        CacheImpl c = (CacheImpl)this.getCache();
        File folder = c.getSubFolder(url);
        UUID hash = c.getHash(url.toString());
        return new File(folder, String.valueOf(hash.toString()) + ".properties");
    }

    protected IFileInfo readLocalFileInfo(URL url) throws CoreException {
        BufferedInputStream in = null;
        Properties loadProps = new Properties();
        try {
            in = new BufferedInputStream(new FileInputStream(this.getFileInfoFile(url)));
            loadProps.load(in);
        }
        catch (FileNotFoundException e) {
            IOUtils.close(in);
            return null;
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)in);
        return new FileInfoBuilder(loadProps);
    }

    protected void saveLocalFileInfo(URL url, IFileInfo fileInfo) throws CoreException {
        FileInfoBuilder fiBld = fileInfo instanceof FileInfoBuilder ? (FileInfoBuilder)fileInfo : new FileInfoBuilder(fileInfo);
        Properties saveProps = new Properties();
        fiBld.addProperties(saveProps);
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.getFileInfoFile(url)));
                saveProps.store(out, null);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }
}

