/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.policy;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.buckminster.download.ICache;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.FileReader;
import org.eclipse.buckminster.download.policy.AbstractFetchPolicy;
import org.eclipse.buckminster.download.policy.Hex;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class DigestPolicy
extends AbstractFetchPolicy {
    public static final int DEFAULT_MAX_DIGEST_AGE = 30000;
    public static final int MAX_RETRIES = 3;
    private final String algorithm;
    private final URL remoteDigest;
    private final IConnectContext connectContext;
    private final int digestLength;
    private final int maxDigestAge;

    public DigestPolicy(ICache cache, URL remoteDigest, IConnectContext cctx, String algorithm, int maxDigestAge) throws CoreException {
        super(cache);
        this.remoteDigest = remoteDigest;
        this.algorithm = algorithm;
        this.maxDigestAge = maxDigestAge;
        this.connectContext = cctx;
        try {
            this.digestLength = MessageDigest.getInstance(algorithm).getDigestLength();
        }
        catch (NoSuchAlgorithmException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public boolean update(URL remoteFile, File localFile, boolean checkOnly, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        byte[] remoteDgst = null;
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(checkOnly ? 100 : 1000));
        try {
            byte[] localDigest;
            File localDigestFile = this.getLocalDigest(localFile);
            if (localFile.exists()) {
                boolean localDigestCalculated = false;
                long digestTS = localDigestFile.lastModified();
                if (digestTS != 0L) {
                    long digestAge = System.currentTimeMillis() - digestTS;
                    if (digestAge < (long)this.maxDigestAge) {
                        return false;
                    }
                    localDigest = this.readLocalDigest(localDigestFile);
                } else {
                    localDigest = this.calculateDigest(localFile);
                    localDigestCalculated = true;
                }
                remoteDgst = this.readRemoteDigest();
                if (Arrays.equals(remoteDgst, localDigest)) {
                    if (localDigestCalculated) {
                        this.writeLocalDigest(localDigestFile, localDigest);
                    } else {
                        localDigestFile.setLastModified(System.currentTimeMillis());
                    }
                    return false;
                }
                if (checkOnly) {
                    return true;
                }
            } else {
                if (checkOnly) {
                    return true;
                }
                remoteDgst = this.readRemoteDigest();
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
            File tempFile = new File(String.valueOf(localFile.getPath()) + ".tmp");
            IProgressMonitor subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)800);
            int idx = 0;
            while (true) {
                block26: {
                    try {
                        localDigest = this.readRemoteFile(remoteFile, tempFile, fiHandle, subMon);
                    }
                    catch (CoreException e) {
                        Throwable cause;
                        tempFile.delete();
                        if (idx < 3 && (cause = e.getStatus().getException()) instanceof ConnectException) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50);
                            break block26;
                        }
                        throw e;
                    }
                    if (Arrays.equals(remoteDgst, localDigest)) {
                        DigestPolicy.safeRename(tempFile, localFile);
                        this.writeLocalDigest(localDigestFile, localDigest);
                        return true;
                    }
                    tempFile.delete();
                    if (idx >= 3) {
                        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.digest_mismatch_reading_0, (Object)remoteFile), (Object[])new Object[0]);
                    }
                }
                ++idx;
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    protected byte[] calculateDigest(File content) throws CoreException {
        byte[] byArray;
        FileInputStream input = null;
        MessageDigest md = this.getDigest();
        try {
            int count;
            byte[] buf = new byte[8192];
            input = new FileInputStream(content);
            while ((count = ((InputStream)input).read(buf)) >= 0) {
                md.update(buf, 0, count);
            }
            byArray = md.digest();
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        return byArray;
    }

    protected MessageDigest getDigest() throws CoreException {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected File getLocalDigest(File localFile) {
        return new File(String.valueOf(localFile.getPath()) + '.' + this.algorithm.toLowerCase(Locale.ENGLISH));
    }

    protected byte[] readLocalDigest(File localDigestFile) throws CoreException {
        byte[] byArray;
        FileInputStream input = null;
        try {
            input = new FileInputStream(localDigestFile);
            byArray = Hex.readHex(localDigestFile.getPath(), input, this.digestLength);
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        return byArray;
    }

    protected byte[] readRemoteDigest() throws CoreException, FileNotFoundException {
        FileReader reader = new FileReader(this.connectContext);
        BytesFromHexBuilder digestByteBuilder = new BytesFromHexBuilder(this.digestLength);
        reader.readInto(this.remoteDigest, digestByteBuilder, null);
        return digestByteBuilder.getBytes();
    }

    protected byte[] readRemoteFile(URL url, File localFile, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        MessageDigest md = this.getDigest();
        DigestOutputStream output = null;
        try {
            File parentFolder = localFile.getParentFile();
            if (parentFolder != null) {
                parentFolder.mkdirs();
            }
            output = new DigestOutputStream(new FileOutputStream(localFile), md);
            FileReader retriever = new FileReader(this.connectContext);
            retriever.readInto(url, output, monitor);
            IFileInfo fi = retriever.getLastFileInfo();
            this.saveLocalFileInfo(url, fi);
            if (fiHandle != null) {
                fiHandle[0] = fi;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
        return md.digest();
    }

    protected void writeLocalDigest(File localDigestFile, byte[] localDigest) throws CoreException {
        FileOutputStream output = null;
        try {
            try {
                File parentFolder = localDigestFile.getParentFile();
                if (parentFolder != null) {
                    parentFolder.mkdirs();
                }
                output = new FileOutputStream(localDigestFile);
                Hex.writeHex(localDigest, output);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
    }

    static class BytesFromHexBuilder
    extends ByteArrayOutputStream {
        private final int byteCount;

        public BytesFromHexBuilder(int digestLength) {
            this.byteCount = digestLength * 2;
        }

        public synchronized byte[] getBytes() throws CoreException {
            if (this.byteCount > this.count) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.digest_not_fully_read_expected_0_got_1, (Object)String.valueOf(this.byteCount), (Object)String.valueOf(this.count)), (Object[])new Object[0]);
            }
            return Hex.decode(this.buf, this.byteCount);
        }
    }
}

