/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.List;
import org.eclipse.buckminster.maven.internal.GroupAndArtifact;
import org.eclipse.buckminster.maven.internal.IMapEntry;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class MapEntry
extends GroupAndArtifact
implements IMapEntry {
    public static final String TAG = "entry";
    public static final String ATTR_NAME = "name";
    private final String name;
    private final List<GroupAndArtifact> aliases;

    public MapEntry(String name, String groupId, String artifactId, List<GroupAndArtifact> aliases) {
        super(groupId, artifactId);
        this.name = name;
        this.aliases = Utils.createUnmodifiableList(aliases);
    }

    @Override
    public List<GroupAndArtifact> getAliases() {
        return this.aliases;
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME, (String)this.name);
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        for (GroupAndArtifact alias : this.aliases) {
            alias.toSax(receiver, namespace, prefix, "alias");
        }
    }
}

